% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.iNEXT}
\alias{plot.iNEXT}
\title{Plotting iNEXT object}
\usage{
\method{plot}{iNEXT}(x, type = 1, se = TRUE, show.legend = TRUE,
  show.main = TRUE, col = NULL, ...)
}
\arguments{
\item{x}{an \code{iNEXT} object computed by \code{\link{iNEXT}}.}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{se}{a logical variable to display confidence interval around the estimated sampling curve.}

\item{show.legend}{a logical variable to display legend.}

\item{show.main}{a logical variable to display title.}

\item{col}{a vector for plotting color}

\item{...}{arguments to be passed to methods, such as graphical parameters (\code{\link{par}}).}
}
\description{
\code{plot.iNEXT}: Plotting method for objects inheriting from class "iNEXT"
}
\examples{
data(spider)
# single-assemblage abundance data
out1 <- iNEXT(spider$Girdled, q=0, datatype="abundance")
plot(x=out1, type=1)
plot(x=out1, type=2)
plot(x=out1, type=3)

}

