/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.HalfNormalDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class HalfNormalGen
extends RandomVariateGen {
    protected double mu;
    protected double sigma;

    public HalfNormalGen(RandomStream s, double mu, double sigma) {
        super(s, new HalfNormalDist(mu, sigma));
        this.setParams(mu, sigma);
    }

    public HalfNormalGen(RandomStream s, HalfNormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return HalfNormalDist.inverseF(mu, sigma, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }
}

