% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2_snp.R
\name{h2_snp}
\alias{h2_snp}
\title{An exact method for SNP-heritability estimation using GWAS summary statistics}
\usage{
h2_snp(beta, SE, N, R, alpha)
}
\arguments{
\item{beta}{a vector of beta coefficients for a set of SNPs. These coefficients are from a GWAS.}

\item{SE}{a vector of the standard errors of the beta coefficients.}

\item{N}{a vector of sample sizes used by the GWAS at these SNPs.}

\item{R}{LD matrix for these SNPs.}

\item{alpha}{\eqn{1-\alpha} is the confidence level of the confidence interval.}
}
\value{
A list containing the following components:

* MLE of the heritability.

* umvu (uniformly minimum variance unbiased) estimator of the heritability.

* interval estimate for the heritability.
}
\description{
\code{h2_snp} calculates heritability explained by a set of SNPs
  
%% ~~ If necessary, more details than the description above ~~
}
\examples{
beta = c(0.225269, 0.221270, 0.162635, 0.261669, 0.150887, 
         0.214515, 0.170296, 0.204454, 0.254811, 0.213803)
SE = c(0.033244, 0.032551, 0.032171, 0.031042, 0.032815, 
       0.031908, 0.031717, 0.032023, 0.031907, 0.032291)
N = 10000
R = diag(1, 10)
alpha = 0.05
h2_snp(beta, SE, N, R, alpha)
}
\references{
Wang, K. (2023) An exact method for SNP-heritability estimation using GWAS summary statistics without heritability modeling. \emph{submitted}
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
