\name{ttsCaret}
\alias{ttsCaret}

\encoding{latin1}

\title{Train time series by \code{caret} and produce two types of time series forecasts: static and recursive}

\description{
It generates both the static and recursive time series plots of machine learning prediction object generated by package \code{caret}.
}

\usage{

ttsCaret(
  y,
  x=NULL,
  method,
  train.end,
  arOrder=2,
  xregOrder=0,
  type,
  tuneLength =10,
  preProcess = NULL,
  resampling="boot",
  Number=NULL,
  Repeat=NULL)

}

\arguments{
  \item{y}{
The time series vector of target variable, or the dependent variable, with \code{zoo} format, must have dimension. y can be either binary or continuous.
}

  \item{x}{ The time series matrix of input variables, or the independent variables, with \code{zoo} format.
}

  \item{method}{The train_model_list of \code{caret}. While using this, make sure that the method allows regression. Methods in c("svm","rf","rpart","gamboost","BstLm","bstSm","blackboost") are feasible.

}


  \item{train.end}{The end date of training data, must be specificed.The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}


\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=0:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{type}{The additional input variables. We have four selection:\cr "none"=no other variables,\cr "trend"=inclusion of time dummy, \cr "season"=inclusion of seasonal dummies, \cr "both"=inclusion of both trend and season. No default.

}

\item{tuneLength}{The same as the length specified in  train function of package \code{caret}.

}


\item{preProcess}{Whether to pre-process the data, current possibilities are "BoxCox", "YeoJohnson", "expoTrans", "center", "scale", "range", "knnImpute", "bagImpute", "medianImpute", "pca", "ica" and "spatialSign".The default is no pre-processing. }


\item{resampling}{The method for resampling, as trainControl function list in package \code{caret}. The default is "boot" for  bootstrapping with 25 replications. Current choices are c("cv","boot","repeatedcv","LOOCV") where "cv" is K-fold CV with a default K=10 or specified by the "Number" below, "LOOCV" denotes the leave-one-out CV}

\item{Number}{The number of K for K-Fold CV, default (NULL) is 10; for "boot" option, the default number of replications is 25}

\item{Repeat}{The number for the repeatition for "repeatedcv". }

}


\details{

This function calls the train function of package \code{caret} to execute estimation. When execution finished, we compute two types of time series forecasts: static and recursive.
}

\value{

  \item{output}{Output object generated by train function of \code{caret}.}
  \item{arOrder}{The autoregressive order of the target variable used.}
  \item{data}{The dataset of imputed.}
  \item{dataused}{The data used by arOrder, xregOrder, and type.}
  \item{training.Pred}{All tuned prediction values of training data, using besTunes to extract the best prediction.}
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
## Machine Learning by library(caret)
library(zoo)
#Case 1. Low frequency
data("macrodata")
dep <- macrodata[569:669,"unrate",drop=FALSE]
ind <- macrodata[569:669,-1,drop=FALSE]
train.end <- "2018-12-01"# Choosing the end dating of train

models <- c("glm","knn","nnet","rpart","rf","svm","enet","gbm","lasso","bridge")[2]
type <- c("none","trend","season","both")[1]
Caret <- ttsCaret(y=dep, x=NULL, arOrder=c(1), xregOrder=c(1),
 method=models, tuneLength =1, train.end, type=type,
 resampling=c("boot","cv","repeatedcv")[2],preProcess = "center")
 testData1 <- window(Caret$data,start="2019-01-01",end=end(Caret$data))
P1 <- iForecast(Model=Caret,newdata=testData1,type="staticfit")
P2 <- iForecast(Model=Caret,newdata=testData1,type="recursive")

tail(cbind(testData1[,1],P1,P2))

#Case 2. High frequency
#head(ES_15m)
#head(ES_Daily)
#dep <- ES_15m #SP500 15-minute realized absolute variance
#ind <- NULL
#train.end <- as.character(rownames(dep))[as.integer(nrow(dep)*0.9)]

#models<-c("svm","rf","rpart","gamboost","BstLm","bstSm","blackboost")[1]
#type<-c("none","trend","season","both")[1]
# Caret <- ttsCaret(y=dep, x=ind, arOrder=c(3,5), xregOrder=c(0,2,4),
# method=models, tuneLength =10, train.end, type=type,
# resampling=c("boot","cv","repeatedcv")[2],preProcess = "center")
#testData1<-window(Caret$data,start="2009-01-01",end=end(Caret$data))
#P1<-iForecast(Model=Caret,newdata=testData1,type="staticfit")
#P2<-iForecast(Model=Caret,newdata=testData1,type="recursive")

}

