% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_anarbe.R
\name{collectData_txt_anarbe}
\alias{collectData_txt_anarbe}
\title{collect data from different txt.}
\source{
http://www4.gipuzkoa.net/oohh/web/esp/02.asp
}
\usage{
collectData_txt_anarbe(folderName, output = TRUE,
  rangeWord = c("Ene       ", -1, "Total     ", -6))
}
\arguments{
\item{folderName}{A string showing the folder path.}

\item{output}{A boolean showing whether the result is given.}

\item{rangeWord}{A list containing the keyword and the shift. 
defaut is set to be used in spain gauging station.}
}
\value{
The collected data from different txt files.
}
\description{
collect data from different txt.
}
\examples{
  
#use internal data as an example.

\dontrun{
file <- system.file("extdata", "1999.csv", package = "hyfo")
folder <- strsplit(file, '1999')[[1]][1]
a <- collectData_txt_anarbe(folder)
}


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item http://www4.gipuzkoa.net/oohh/web/esp/02.asp
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.
}
}
