% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPreciBar(generic).R
\docType{methods}
\name{getPreciBar}
\alias{getPreciBar}
\alias{getPreciBar,list-method}
\alias{getPreciBar,data.frame-method}
\title{get mean rainfall bar plot of the input dataset or time series.}
\usage{
getPreciBar(data, method, cell = "mean", output = "data", name = NULL,
  plotRange = TRUE, member = NULL, omitNA = TRUE, info = FALSE, ...)

\S4method{getPreciBar}{list}(data, method, cell = "mean", output = "data",
  name = NULL, plotRange = TRUE, member = NULL, omitNA = TRUE,
  info = FALSE, ...)

\S4method{getPreciBar}{data.frame}(data, method, cell = "mean",
  output = "data", name = NULL, plotRange = TRUE, member = NULL,
  omitNA = TRUE, info = FALSE, ...)
}
\arguments{
\item{data}{A list containing different information, should be the result of reading netcdf file using
\code{\link{loadNcdf}}, or a time series, with first column the Date, second the value.
Time series can be an ENSEMBLE containning different members. Than the mean value will be given and the range will be given.}

\item{method}{A string showing the calculating method of the input time series. More information
please refer to the details.}

\item{cell}{A vector containing the locaton of the cell, e.g. c(2, 3), default is "mean", representing
the spatially averaged value. Check details for more information.}

\item{output}{A string showing the type of the output, if \code{output = 'ggplot'}, the returned 
data can be used in ggplot and \code{getPreciBar_comb()}; if \code{output = 'plot'}, the returned data is the plot containing all 
layers' information, and can be plot directly or used in grid.arrange; if not set, the data
will be returned.}

\item{name}{If \code{output = 'ggplot'}, name has to be assigned to your output, in order to differentiate
different outputs in the later multiplot using \code{getSpatialMap_comb}.}

\item{plotRange}{A boolean showing whether the range will be plotted.}

\item{member}{A number showing which member is selected to get, if the dataset has a "member" dimension. Default
is NULL, if no member assigned, and there is a "member" in dimensions, the mean value of the members will be
taken.}

\item{omitNA}{A boolean showing whether the missing value is omitted.}

\item{info}{A boolean showing whether the information of the map, e.g., max, mean ..., default is FALSE.}

\item{...}{\code{title, x, y} showing the title and x and y axis of the plot. e.g. \code{title = 'aaa'}}
}
\value{
The calculated mean value of the input time series and the plot of the result.
}
\description{
get mean rainfall bar plot of the input dataset or time series.
}
\details{
There are following methods to be selected, 
"annual": annual rainfall of each year is plotted.  
"winter", "spring", "autumn", "summer": seasonal rainfall of each year is plotted.
Month(number 1 to 12): month rainfall of each year is plotted, e.g. march rainfall of each year.
"meanMonthly": the mean monthly rainfall of each month over the whole period.

#Since "winter" is a crossing year, 12, 1, 2, 12 is in former year, and 1, 2 are in latter year.
#so winter belongs to the latter year.


\code{cell} representing the location of the cell, NOTE: this location means the index of the cell,
IT IS NOT THE LONGITUDE AND LATITUDE. e.g., \code{cell = c(2, 3)}, the program will take the 2nd longitude
and 3rd latitude, by the increasing order. Longitude comes first.


It is a generic function, if in your case you need to debug, please see \code{?debug()} 
for how to debug S4 method.
}
\examples{
#gridData provided by package is the result of \\code{loadNcdf()}
data(tgridData)
b1 <- getPreciBar(tgridData, method = 'annual')
b2 <- getPreciBar(tgridData, method = 'meanMonthly')

data(testdl)
TS  <- testdl[[1]]
a <- getPreciBar(TS, method = 'spring')
# if info = T, the information will be given at the bottom.
a <- getPreciBar(TS, method = 'spring', info = TRUE)


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item Hadley Wickham (2007). Reshaping Data with the reshape Package. Journal of Statistical Software,
21(12), 1-20. URL http://www.jstatsoft.org/v21/i12/.
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.
}
}
