% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shp2cat.R
\name{shp2cat}
\alias{shp2cat}
\title{Get a catchment object from selected shape file.}
\usage{
shp2cat(filePath)
}
\arguments{
\item{filePath}{A string representing the path of the shape file.}
}
\value{
A catchment object can be used in \code{getSpatialMap()}.
}
\description{
Get a catchment object from selected shape file.
}
\details{
This function is based on the package \code{rgdal} and \code{sp}, and the output comes from the package
\code{sp}
}
\examples{
#open internal file
file <- system.file("extdata", "testCat.shp", package = "hyfo")
catchment <- shp2cat(file)

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item Roger Bivand, Tim Keitt and Barry Rowlingson (2015). rgdal: Bindings for the Geospatial Data
Abstraction Library. R package version 1.0-4. http://CRAN.R-project.org/package=rgdal

\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL http://www.R-project.org/.
}
}

