% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdf.R
\name{loadNcdf}
\alias{loadNcdf}
\title{Load NetCDF file}
\usage{
loadNcdf(filePath, varname, tz = "GMT", ...)
}
\arguments{
\item{filePath}{A path pointing to the NetCDF file, version3.}

\item{varname}{A character representing the variable name, you can use \code{getNcdfVar} to
get the basic information about the variables and select the target.}

\item{tz}{A string representing the time zone, default is GMT, if you know what time zone is
you can assign it in the argument. If \code{tz = ''}, current time zone will be taken.}

\item{...}{Several arguments including Year, month, lon, lat
type in \code{?downscaleNcdf} for details.You can load while downscale,
and also first load than use \code{downscaleNcdf} to downscale.}
}
\value{
A list object from \code{hyfo} containing the information to be used in the analysis,
or biascorrection.
}
\description{
Load NetCDF file
}
\examples{
# First open the test NETcDF file.
filePath <- system.file("extdata", "tnc.nc", package = "hyfo")

# Then if you don't know the variable name, you can use \\code{getNcdfVar} to get variable name
varname <- getNcdfVar(filePath)

nc <- loadNcdf(filePath, varname)

# you can directly add your downscale information to the argument.
nc1 <- loadNcdf(filePath, varname, year = 2006, lon = c(-2, -0.5), lat = c(43.2, 43.7))
nc2 <- loadNcdf(filePath, varname, year = 2005, month = 3:8, lon = c(-2, -0.5),
lat = c(43.2, 43.7))

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item David Pierce (2014). ncdf: Interface to Unidata netCDF data files. R package version 1.6.8.
http://CRAN.R-project.org/package=ncdf

\item Santander MetGroup (2015). ecomsUDG.Raccess: R interface to the ECOMS User Data Gateway. R package
version 2.2-6. http://meteo.unican.es/ecoms-udg
}
}

