% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_timeseries}
\alias{get_timeseries}
\title{Get time series corresponding to a station}
\usage{
get_timeseries(subdomain = c("kyy", "ypaat", "emy"), stationID)
}
\arguments{
\item{subdomain}{One of the subdomains of hydroscope.gr}

\item{stationID}{A station ID}
}
\value{
If \code{subdomain} is one of \code{"kyy"} (Ministry of Environment
and Energy), \code{"ypaat"} (Ministry of Rural Development and Food) or
\code{"emy"} (National Meteorological Service) and stationID is not NULL,
returns a dataframe with time series data from the corresponding station and
database of hydroscope.gr. Otherwise gives an error message.

 If the station ID does not exist in the database, or the url from hydroscope
 could not parsed, returns a dataframe with NA values.

The dataframe columns are:
\describe{
    \item{TimeSeriesID}{The time series ID from the database}
    \item{Name}{The time series name}
    \item{Variable}{The time series variable type}
    \item{TimeStep}{The timestep of time series}
    \item{Unit}{The units of the time series}
    \item{Remarks}{Remarks from Hydroscope}
    \item{Instrument}{The instrument ID}
    \item{StartDate}{The starting date of time series values}
    \item{EndDate}{The ending date of time series values}
    \item{StationID}{The corresponding station's ID}
}
}
\description{
\code{get_timeseries} returns a dataframe with the available time series from
a station in a database of Hydroscope.
}
\note{
Stations' and time series' IDs might not be unique at the different databases
records from the different Hydroscope domains.

The codes used in Variable are:
\tabular{ll}{
\strong{Code}  \tab \strong{Name} \cr
wind_direc \tab Wind Direction \cr
wind_speed \tab Wind Speed \cr
wind_speed_av \tab  Average Wind Speed\cr
calcium \tab Calcium Concentration  \cr
rain_snow \tab Rain and Snow Height  \cr
rainfall \tab Rain Height  \cr
snow \tab Snow Height  \cr
evap_estim \tab Estimated Evaporation   \cr
evap_actual \tab Measured Evaporation \cr
flow \tab Discharge  \cr
pressure \tab Atmospheric Pressure  \cr
water_level_flood \tab Flood Water Level   \cr
air_temp \tab Air Temperature  \cr
ground_temp \tab Ground Temperature  \cr
ground_temp_min \tab Minimum Ground Temperature  \cr
ground_temp_max \tab Maximum Ground Temperature  \cr
temp_min \tab Minimum Air Temperature  \cr
temp_max \tab Maximum Air Temperature  \cr
humid_absol \tab Absolute Humidity  \cr
humid_rel \tab Relative Humidity  \cr
}
}
\examples{
# get station's time series from the Greek Ministry of Environment and Energy
get_timeseries("kyy", 200171)

\dontrun{
get_timeseries("ypaat")
}

}
\references{
Stations' data are retrieved from the Hydroscope's databases:
\itemize{
\item Ministry of Environment, Energy and Climate Change,
\url{http://kyy.hydroscope.gr}
\item Ministry of Rural Development and Food,
\url{http://ypaat.hydroscope.gr}
\item National Meteorological Service,
\url{http://emy.hydroscope.gr}
}
}
\author{
Konstantinos Vantas, \email{kon.vantas@gmail.com}
}
