% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigate_network_dfs.R
\name{navigate_network_dfs}
\alias{navigate_network_dfs}
\title{Navigate all Paths Depth First}
\usage{
navigate_network_dfs(x, starts, direction = "down", reset = FALSE)
}
\arguments{
\item{x}{data.frame containing hydroloom compatible network or list
as returned by \link{make_index_ids} (for down) or \link{make_fromids}
(for up). The list formats avoids recreating the index ids for every call
to navigate network dfs in the case that it needs to be called many times.}

\item{starts}{vector with ids from x to start at.}

\item{direction}{character "up or "down"}

\item{reset}{logical if TRUE, reset graph for each start such that later paths
will have overlapping results.}
}
\value{
list containing dfs result for each start.
}
\description{
given a starting node, return all reachable paths. Once visited,
a node is marked as visited and will not take part in a future path.
}
\examples{

x <- hy(sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom")))

x <- add_toids(x, return_dendritic = FALSE)

navigate_network_dfs(x, 8893402)

navigate_network_dfs(x, 8897784, direction = "up")

}
