%% Part of the hydroPSO R package, http://www.rforge.net/hydroPSO/ ; 
%%                                 http://cran.r-project.org/web/packages/hydroPSO
%% Copyright 2011-2012 Mauricio Zambrano-Bigiarini & Rodrigo Rojas
%% Distributed under GPL 2 or later

\name{verification}
\alias{verification}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
verification
}
\description{
Run the model and get a goodness-of-fit value by comparing the simulated values against observations for the optimum parameter set found by optimisation
}
\usage{
verification(fn="hydromod", par, control=list(), 
             model.FUN=NULL, model.FUN.args=list() )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fn}{
character, name of a valid R function to be optimised or character value \kbd{'hydromod'}. When \code{fn='hydromod'} the algorithm uses \code{model.FUN} and \code{model.FUN.args} to extract the values simulated by the model and to compute its corresponding goodness-of-fit function. When \code{fn!='hydromod'} the algorithm uses the value(s) returned by \code{fn} as both model output and its corresponding goodness-of-fit \cr
When \code{fn='hydromod'} the algorithm will optimise the model defined by \code{model.FUN} and \code{model.args}
}
%%\item{\dots}{
%%further arguments to be passed to \code{fn}
%%}
  \item{par}{
numeric, or matrix/data.frame with the parameter sets that will be used for verification \cr
Parameter sets in \code{par} must be stored by row, i.e., each different row represents a different parameter set
}
  \item{control}{
a list of control parameters. See \sQuote{Details}
}
  \item{model.FUN}{
OPTIONAL. Only used when \code{fn='hydromod'} \cr
character, valid R function representing the model code to be calibrated/optimised
} 
  \item{model.FUN.args}{
OPTIONAL. Only used when \code{fn='hydromod'} \cr
list with the arguments to be passed to \code{model.FUN}
} 

}
\details{
The \code{control} argument is a list that can supply any of the following components:
  \describe{  
      
  \item{drty.in}{
character, path to the directory storing the input files required for PSO, i.e. \sQuote{ParamRanges.txt} and \sQuote{ParamFiles.txt}
}
  \item{drty.out}{
character, path to the directory storing the output files generated by \kbd{hydroPSO}
}
  \item{digits}{
OPTIONAL. Only used when \code{write2disk=TRUE} \cr
numeric, number of significant digits used for writing the outputs in scientific notation
}
  \item{gof.name}{
character, ONLY used for identifying the goodness-of-fit of each model run and writing it to the \kbd{LH_OAT-gof.txt} output file
}
  \item{MinMax}{
character, indicates whether the optimum value for the analysed problem corresponds to the minimum or maximum of the the objective function. It is used to select the \sQuote{best} parameter set.
Valid values are in: \code{c('min', 'max')}
}
  \item{do.plots}{
logical, if TRUE a PNG plot with the comparison between observed and simulated values is produced for each parameter set used in the LH-OAT
}
  \item{write2disk}{
logical, indicates if the output files will be written to the disk 
}
  \item{verbose}{
logical, if TRUE progress messages are printed
}
%%  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
%%}
  }
}
%%\details{
%%  ~~ If necessary, more details than the description above ~~
%%}
\value{
A list of two elements: \cr 
%%\item{sim}{simulated values obtained by running the model}
\item{gofs}{goodness-of-fit values corresponding to each one of the parameter sets provided in \code{par}}
\item{best.gof}{goodness-of-fit of the "best" parameter set found during the verification round}
\item{best.par}{parameter values of the "best" paraemter set found during the verification round}
}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{hydromod}}
}
%%\examples{
%%
%%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{optimize}
\keyword{files}% __ONLY ONE__ keyword per line
