% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_step.R
\name{direct_step}
\alias{direct_step}
\title{Uses the direct step method to find the distance between two known depths
in a trapezoidal channel}
\usage{
direct_step(
  So = NULL,
  n = NULL,
  Q = NULL,
  y1 = NULL,
  y2 = NULL,
  b = NULL,
  m = NULL,
  nsteps = 1,
  units = c("SI", "Eng"),
  ret_units = FALSE
)
}
\arguments{
\item{So}{numeric channel bed slope [unitless]}

\item{n}{numeric vector that contains the Manning roughness coefficient}

\item{Q}{numeric vector that contains the flow rate [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{y1}{numeric vector that contains the initial water depth [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{y2}{numeric vector that contains the final water depth [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{b}{numeric vector that contains the channel bottom width [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{m}{numeric vector that contains the side slope of the channel (m:1 H:V) [unitless]}

\item{nsteps}{integer of the number of calculation steps between y1 and y2 [unitless]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package.}

\item{ret_units}{If set to TRUE the value(s) returned are of class \code{units} with
units attached to the value. [Default is FALSE]}
}
\value{
Returns a data frame (tibble) with the columns:
\itemize{
  \item x - cumulative distance from position of y1
  \item z - elevation of the channel bed at location x
  \item y - depth of the water at location x
  \item A - cross-sectional area at location x
  \item Sf - slope of the energy grade line at location x
  \item E - specific energy at location x
  \item Fr - Froude number at location x
}
}
\description{
This function applies the direct step method for a gradually-varying water 
surface profile for flow in an open channel with a trapezoidal shape.
}
\details{
The direct step method applies the energy equation to gradually-varied 
open channel flow conditions, assuming each increment is approximately uniform.
This function works with a trapezoidal channel shape. The water depths at two 
locations are input with channel geometry and flow rate, and the distance between
the two locations, \eqn{{\Delta}X}, is calculated: 
\deqn{{\Delta}X = \frac{E_1 - E_2}{S_f-S_o}}
where \eqn{E_1}{E1} and  \eqn{E_2}{E2} are the specific energy values at the locations 
of \eqn{y_1}{y1} and  \eqn{y_2}{y2},  \eqn{S_f}{Sf} is the slope of the energy grade line, 
and \eqn{S_o}{So} is the slope of the channel bed.
}
\examples{

#Solving for profile between depths 3.1 ft and 3.4 ft in a rectangular channel
#Flow of 140 ft^3/s, bottom width = 6 ft:
direct_step(So=0.0015, n=0.013, Q=140, y1=3.1, y2=3.4, b=6, m=0, nsteps=2, units="Eng")

}
\author{
Ed Maurer
}
