% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydSpatRaster.R
\name{hydSpatRaster}
\alias{hydSpatRaster}
\title{Initialize a \code{SpatRaster} for the flood-functions}
\usage{
hydSpatRaster(filename_dem = "", filename_csa = "", ext, crs, ...)
}
\arguments{
\item{filename_dem}{an optional argument of length 1 with type
\code{character} specifying a filename of a \strong{d}igital \strong{e}levation
\strong{m}odel raster dataset.

If the file exists it is imported via \code{\link[terra]{rast}} and used
to build the \code{SpatRaster}, potentially cropped by argument
\code{ext}. If the dem file does not exist, data are downloaded
automatically and exported using \code{\link[terra]{writeRaster}} and can
be reused to accelerate later computations.

An existing dataset must be either in the coordinate reference system (crs)
'ETRS 1989 UTM 32N' (epsg: 25832) for the River Rhine or 'ETRS 1989 UTM 33N'
(epsg: 25833) for the River Elbe. It must also overlap with the active
floodplains (\code{\link{sf.afe}} or \code{\link{sf.afr}}) of the river
selected through the crs.

If argument \code{filename_csa} is specified and exists too,
the coordinate reference system (\code{\link[terra]{crs}}), extent
(\code{\link[terra]{ext}}) and resolution (\code{\link[terra]{res}})
of both raster datasets must match.

Supported file types depend on available
\href{https://gdal.org/en/latest/drivers/raster/index.html}{GDAL raster drivers}.}

\item{filename_csa}{an optional argument of length 1 with type
\code{character} specifying a filename of a \strong{c}ross \strong{s}ection
\strong{a}rea raster dataset.

If the file exists it is imported via \code{\link[terra]{rast}} and used
to build the \code{SpatRaster}, potentially cropped by argument
\code{ext}. If the csa file does not exist, data are downloaded
automatically and exported using \code{\link[terra]{writeRaster}} and can
be reused to accelerate later computations.

An existing dataset must be either in the coordinate reference system (crs)
'ETRS 1989 UTM 32N' (epsg: 25832) for the River Rhine or 'ETRS 1989 UTM 33N'
(epsg: 25833) for the River Elbe. It must also overlap with the active
floodplains (\code{\link{sf.afe}} or \code{\link{sf.afr}}) of the river
selected through the crs and be in the possible range of \code{station_int}
values: Elbe (m 0 - 585700), Rhine (m 336200 - 865700).

If argument \code{filename_dem} is specified too, coordinate reference
system (\code{\link[terra]{crs}}), extent (\code{\link[terra]{ext}})
and resolution (\code{\link[terra]{res}}) of both raster datasets must
match.

Supported file types depend on available
\href{https://gdal.org/en/latest/drivers/raster/index.html}{GDAL raster drivers}.}

\item{ext}{optional argument of type \code{\link[terra]{SpatExtent}}. If neither
\code{filename_dem} nor \code{filename_csa} are specified, \code{ext} is
required to download the respective data and generate temporary dem and csa
datasets. If either \code{filename_dem} or \code{filename_csa} or both are
specified, \code{ext} must be within the extent of provided raster layers.
Then it is used to \code{\link[terra]{crop}} the supplied data.}

\item{crs}{optional argument of type \code{\link[sf:st_crs]{crs}} or
\code{\link[terra]{crs}}. If
neither \code{filename_dem} nor \code{filename_csa} are specified,
\code{crs} is used to select the respective river (Elbe:
'ETRS 1989 UTM 33N' (epsg: 25833); Rhine: 'ETRS 1989 UTM 32N' (epsg:
25832)) and \code{\link[terra]{crop}} downloaded dem and csa
by the given \code{ext}. If either \code{filename_dem} or
\code{filename_csa} or both are specified, \code{crs} must match their
coordinate reference systems; otherwise an error is returned.}

\item{\dots}{additional parameters passed to
\code{\link[terra]{writeRaster}}.}
}
\value{
\code{SpatRaster} object containing digital elevation (\code{dem})
and cross section area (\code{csa}) raster layers.
}
\description{
To initialize an object of class \code{\link[terra]{SpatRaster}}
with layers dem and csa this function should be used. It checks all the
required input data, downloads missing data automatically, clips and
returns the final object, prepared for the \code{flood()} functions
(\code{\link{flood1}}, \code{\link{flood2}} and \code{\link{flood3}}).
}
\details{
Since the underlying tiled digital elevation models (dem) are rather
large datasets hydflood provides options to permanentely cache these
datasets. \code{options("hydflood.datadir" = tempdir())} is the default. To
modify the location of your raster cache to your needs set the respective
\code{options()} prior to loading the package, e.g.
\code{options("hydflood.datadir" = "~/.hydflood");library(hydflood)}. The
location can also be determined through the environmental variable
\env{hydflood_datadir}.

Since downloads of large individual datasets might cause timeouts, it is
recommended to increase \code{options("timeout")}.
}
\examples{
\donttest{
  options("hydflood.datadir" = tempdir())
  options("timeout" = 120)
  library(hydflood)
  
  e <- ext(436500, 438000, 5415000, 5416500)
  c <- st_crs("EPSG:25832")
  
  r <- hydSpatRaster(ext = e, crs = c)
  r
}

}
\references{
\insertRef{wsv_dgmw_2016}{hydflood}

\insertRef{brockmann_auswertung_2008}{hydflood}

\insertRef{brockmann_produktblatt_2012}{hydflood}

\insertRef{brockmann_digitales_2008}{hydflood}

\insertRef{smile_consult_gmbh_dgm-w_2011}{hydflood}

\insertRef{fugro-hgn_gmbh_aufbau_2011}{hydflood}

\insertRef{arge_vermessung_schmid_-_inphoris_aufbau_2012}{hydflood}

\insertRef{weber_dgms_2020}{hydflood}

\insertRef{weber_dgm_elbe_2020}{hydflood}

\insertRef{weber_dgm_rhine_2020}{hydflood}

\insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hydflood}

\insertRef{brunotte_flussauen_data_2009}{hydflood}
}
\seealso{
\code{\link[terra]{SpatRaster-class}},
\code{\link[terra]{rast}}, \code{\link[terra]{writeRaster}},
\code{\link{flood1}}, \code{\link{flood2}}, \code{\link{flood3}},
\code{\link{sf.afe}}, \code{\link{sf.afr}}
}
