% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-docs.R
\docType{package}
\name{huxtable-news}
\alias{huxtable-news}
\title{Changes to the huxtable package}
\description{
This help page simply gives the contents of NEWS.md.
}
\section{huxtable (development version)}{
\itemize{
\item Update \code{by_cases()} to work with dplyr 1.1.0. Within \code{by_cases()}
formulas, \code{.} is now vector rather than matrix. Thanks @DavisVaughan.
}
}

\section{huxtable 5.5.1}{
\itemize{
\item CSS borders are now set explicitly even if they are all set to 0.
\item Bugfix: shell-quote files in \verb{quick_*} functions. Thanks to @ceresek.
\item Bugfix: cope with adjustbox version “1.3a” among latex dependencies.
}
}

\section{huxtable 5.5.0}{
\itemize{
\item Huxtable should work with \href{https://quarto.org}{Quarto} documents.
\itemize{
\item Quarto labels and captions will override huxtable-provided ones.
\item Quarto style references like \verb{@table-label} only work with quarto
labels.
\item Please report any bugs!
}
\item New \code{column_to_header()} function converts a column to header rows.
New \code{as_hux()} method for \code{grouped_df} objects optionally converts
groups to header rows.
\item New convenience functions \code{stripe_rows()} and \code{stripe_columns()}.
\item Add \code{format} and \code{...} options to \code{fmt_percent()} to allow flexible
formatting via \code{formatC()}.
\item \code{add_footnote()} gets an explicit \code{number_format} argument which is
\code{NA} by default.
\item Bugfix: infinite loop with wide characters in \code{to_screen()}.
\item Bugfix: duplicate colnames when exporting
\code{huxreg(..., error_pos = "right")} to flextable.
\item Bugfix: bookdown-style references weren’t working in blogdown.
}
}

\section{huxtable 5.4.0}{
\itemize{
\item New behaviour: setting \code{colspan()} or \code{rowspan()} overwrites the
content of cells that have been shadowed.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
ht <- hux(c(1, 1), c(2, 2), c(3, 3))
ht <- set_all_borders(ht)
colspan(ht)[1, 1] <- 3

# old behaviour                
ht[, c(2, 1, 3)]
##   +--------------------------+
##   |                  2       |
##   +--------+--------+--------+
##   |      2 |      1 |      3 |
##   +--------+--------+--------+

# new behaviour
ht[, c(2, 1, 3)]
##   +--------------------------+
##   |                  1       |
##   +--------+--------+--------+
##   |      2 |      1 |      3 |
##   +--------+--------+--------+
}\if{html}{\out{</div>}}
\item New option \code{huxtable.latex_siunitx_align} allows you to use the LaTeX
\code{siunitx} package to handle decimal point alignment. This is \code{FALSE}
by default.
\item Bugfix: centre alignment was not working in \code{print_screen()}.
\item Bugfix: failure in \code{to_md()} with recent versions of \code{stringi}
package.
\item Bugfix: repeating a single row in a subset, like
\code{ht[c(1, 1, 2, 3), ]}, was setting \code{colspan = 2} on the repeated row.
\item Bugfix: zero-argument subset replacement like \code{ht[] <- ...} wasn’t
working.
}
}

\section{huxtable 5.3.0}{
\itemize{
\item Improve decimal alignment in LaTeX when \code{align(ht) == "."}. This may
change the appearance of some documents.
\item Allow \code{tidy_override()} to extend columns of \code{tidy} and \code{glance}.
\item Bugfix: #196 \code{^} was giving errors in LaTeX.
}
}

\section{huxtable 5.2.0}{
\itemize{
\item Add \code{table_environment} property so you can use e.g. \code{"table*"} in
TeX.
\item Bugfix: \code{print_screen(h, colnames = FALSE)} didn’t print a final
newline.
\item Bugfix: italic from markdown was being printed as underlined in TeX.
\item Minor test update for compatibility with broom.
}
}

\section{huxtable 5.1.1}{
\itemize{
\item Minor test update for compatibility with broom.
\item Fixes for R 4.1.0.
}
}

\section{huxtable 5.1.0}{
\itemize{
\item \code{as_flextable()} now exports markdown in cells to RTF, and to Word
with the help of the optional \code{ftExtra} package. Thanks @atusy for
adding this feature.
\item Improvements to markdown screen export. This now uses the optional
\code{fansi} package.
\item New feature: \code{as_Workbook()} gains \code{start_row} and \code{start_col}
arguments, to write a huxtable into an Excel worksheet starting at a
particular row or column.
\item New feature: \code{huxreg()} gains a \code{glance_args} argument to pass
arguments to \code{glance()}.
\item New feature: \code{options(huxtable.long_minus = TRUE)} will try to use
long minus signs before numbers. The default is \code{FALSE}. It will
probably become \code{TRUE} in a future version.
\item Bugfix: \code{insert_row/column(..., after = 0)} was unsetting table
properties.
\item Bugfix: unicode characters above 32767 were incorrectly represented in
RTF. Thanks @kaigu1990.
\item Bugfix: columns were being collapsed in \code{as_Workbook()}.
\item Bugfix: \code{style_cells} didn’t work unless huxtable was on the search
path.
\item Bugfix: \code{merge_repeated_rows} merged \code{NA} rows incorrectly.
\item Bugfix: number format was not set correctly in \code{huxreg()}’s \code{note}.
\item Bugfix: in \code{huxreg()}, \code{tidy_args} threw an error if the first
argument to \code{tidy()} was a named list.
\item Bugfix: \code{tidy_replace()} was broken.
\item Clearer error messages for \code{tidy_override()} when \code{extend = FALSE}. In
future, \code{extend} will probably default to \code{TRUE}.
}
\subsection{Other news:}{
\itemize{
\item Huxtable received its first Patreon sponsor! Thanks to Ross Mattheis.
}
}
}

\section{huxtable 5.0.0}{
Huxtable 5.0.0 brings numerous changes. For a more user-friendly
introduction, see
\url{https://hughjonesd.github.io/whats-new-in-huxtable-5.0.0.html}.
\subsection{Breaking changes}{
\itemize{
\item There are changes to LaTeX output.
\itemize{
\item LaTeX \verb{\tabcolsep} is now set to 0 within huxtable tables, while
left and right padding should now take effect even when \code{wrap} is
\code{FALSE}.
\item The default LaTeX table environment is now “tabular” unless \code{width}
is set. If \code{width} is set, it is “tabularx”.
\item \code{wrap} only matters if \code{width} is set. Otherwise, cell wrapping is
off.
\item the \verb{\centerbox} macro from the LaTeX “adjustbox” package is used to
centre tables. This should improve centring when tables are too
wide. You may need to update the LaTeX “adjustbox” package to a
recent version. \code{check_latex_dependencies()} can inform you about
this.
}
\item As previously signalled, \code{add_colnames} has now become \code{TRUE} by
default in \code{huxtable()} and \code{as_huxtable()}. Set
\code{options(huxtable.add_colnames = FALSE)} to go back to the old
behaviour.
\item Newlines in cell contents are now respected (in LaTeX, so long as
\code{wrap = TRUE} and \code{width} has been set).
\item Huxtable borders have been reworked, fixing some longstanding bugs and
adding new features.
\itemize{
\item Borders are now automatically collapsed. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{jams \%>\% 
    set_right_border(everywhere, 1, 1) \%>\% 
    set_left_border(everywhere, 2, 0.4)
}\if{html}{\out{</div>}}

will set the border in between the columns of \code{jams} to \code{0.4},
overwriting the previous value. This is more in line with what you
would expect. For example, the following code now does what you
probably want:

\if{html}{\out{<div class="sourceCode">}}\preformatted{jams \%>\% 
    set_rowspan(2, 1, 3) \%>\% 
    set_bottom_border(4, everywhere, 1)
##                 Type              Price  
##                 Strawberry         1.90  
##                                    2.10  
##                                    1.80  
##               ---------------------------
}\if{html}{\out{</div>}}

instead of the old behaviour:

\if{html}{\out{<div class="sourceCode">}}\preformatted{jams \%>\% 
    set_rowspan(2, 1, 3) \%>\% 
    set_bottom_border(4, everywhere, 1)
##                 Type           Price  
##                 Strawberry      1.90  
##                                 2.10  
##                                 1.80  
##                            -----------
}\if{html}{\out{</div>}}
\item \code{set_left_border()}, \code{set_all_borders()} and friends all use a
default value of 0.4. So to set a default border, write e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as_hux(head(iris)) \%>\% 
      set_bottom_border(1, everywhere)
}\if{html}{\out{</div>}}
\item A new \code{brdr()} class encapsulates border thickness, style and
colour. You can set all properties at once by writing, e.g.:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as_hux(jams) \%>\% 
      set_bottom_border(1, everywhere, brdr(1, "dotted", "darkgreen"))
}\if{html}{\out{</div>}}

\code{left_border(ht)} and friends return a \code{brdr} object. To access the
border thickness, write \code{brdr_thickness(left_border(ht))}.
}
\item Various deprecated items have been removed:
\itemize{
\item The 3-argument form of \verb{set_*}. Instead, use \verb{map_*}.
\item The \code{byrow} argument to \verb{set_*}. Instead, use \verb{map_*} and
\code{by_cols()}.
\item \code{error_style} and \code{pad_decimal} arguments in \code{huxreg}. Use
\code{error_format} and \code{align(hx) <- "."}.
\item The \code{where()}, \code{is_a_number()} and \code{pad_decimal()} functions. Use
\verb{map_*} functions, \code{! is.na(as.numeric(x))}, and \code{align(ht) <- "."}.
}
\item Default padding has been increased to 6 points.
\item By default, \code{width()} is now unset.
\item By default, \code{wrap()} is now \code{TRUE}.
\item \code{every()} has been renamed to \code{stripe()}, to avoid a clash with
\code{purrr::every()}. \code{everywhere}, \code{evens} and \code{odds} are still the same.
\item The little-used ability to set \code{copy_cell_props} to a character vector
in \code{rbind.huxtable} and \code{cbind.huxtable} has been removed. You can
still set it to \code{FALSE}.
\item \code{add_rows()} and \code{add_columns()} now always call \code{rbind.huxtable()} or
\code{cbind.huxtable()} and return a huxtable.
\item Huxtable no longer supports dplyr versions less than 0.7.0 (released
mid-2017).
\item \code{set_cell_properties()} has been renamed \code{style_cells()}. It is
retained as a soft-deprecated alias.
\item Various themes have been tweaked:
\itemize{
\item \code{theme_basic()} now has bold headers and no header column by
default.
\item \code{theme_plain()} defaults to \code{position = "centre"}.
\item \code{theme_striped()} uses grey stripes, a white border, and subtler
headers.
\item \code{theme_article()} has thinner borders.
}
}
}

\subsection{Other changes}{
\itemize{
\item You can now use \href{https://commonmark.org/help/}{markdown} within table
cells.
\itemize{
\item Use \code{set_markdown(ht, rows, cols)} to turn this on.
\item Or use the convenience function \code{set_markdown_contents()} to set
cell contents that will be interpreted as markdown.
\item Markdown works for HTML and LaTeX. There’s basic support for
on-screen display.
}
\item Huxtable now has the concept of header row and columns.
\itemize{
\item By default, data frame column names will be headers.
\item To set other rows to be headers, use
\code{set_header_rows(ht, row_numbers, TRUE)}. For columns, use
\code{header_cols()} or \code{set_header_cols()}.
\item New functions \code{style_headers()}, \code{style_header_cols()}, and
\code{style_header_rows()} to set multiple properties on headers.
\item In themes, \code{header_row/col = TRUE} set the first row/col to a
header, and style all header rows/cols.
}
\item \code{set_bold()} and \code{set_italic()} now use a default value of \code{TRUE}. So
you can write e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as_hux(head(iris)) \%>\% 
      set_bold(1, everywhere)
}\if{html}{\out{</div>}}
\item Console output in R now shows table position and caption position.
\item By default, huxtable now sets labels from the current knitr chunk
label, if there is one. This is consistent with \code{kable()}. In
bookdown, you can then do e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Some iris species are shown in \@ref(tab:mytable):

```r
as_hux(iris)
```
}\if{html}{\out{</div>}}

Set \code{options(huxtable.autolabel = FALSE)} to turn off this behaviour.
\item The one-argument form of \code{[} now works for huxtables just as it does
for data frames. For example, \code{ht[2:3]} selects columns 2 and 3.
\item New functions \code{fmt_percent()} and \code{fmt_pretty()} for passing into
\code{number_format()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{jams$Sugar <-c ("Sugar content", 0.4, 0.35, 0.45)
set_number_format(jams, -1, "Sugar", fmt_percent(1))
}\if{html}{\out{</div>}}
\item \code{split_across()} and \code{split_down()} split a huxtable into a list of
sub-tables. Headers can be automatically included.
\item \code{restack_across()} and \code{restack_down()} split a huxtable, then join it
back up. This is useful for making a table fit on a page.
\item \code{merge_across()} and \code{merge_down()} merge an area of cells
horizontally across rows, or vertically down columns.
\item New functions
\verb{set_lr_borders()/_border_colors()/_border_styles()/_padding()}
set left and right borders and padding simultaneously. New functions
\code{set_tb_borders()} etc. set top and bottom properties simultaneously.
There are \code{map_} equivalents of all of these.
\item \code{set_outer_padding()} sets padding around a range of cells, similarly
to \code{set_outer_borders()}.
\item A new table-level property, \code{caption_width()}, allows you to set the
width of the caption. The default, \code{NA}, sets the width equal to the
table width.
\item There are two new themes: \code{theme_compact()} and \code{theme_bright()}.
\item For \code{huxreg()}, a new function \code{tidy_replace()} allows you to replace
the output of \code{tidy(x)} entirely.
\item huxtable now only sets \code{options(huxtable.knit_print_df = TRUE)} if it
is attached, not if it is loaded.
\item huxtable supports \code{dplyr::relocate()}, new in dplyr 1.0.0.
\item Improvements to \code{as_flextable()}.
\item Improvements to \code{quick_pptx()} (thanks @davidgohel).
\item Bugfixes for \code{options(huxtable.use_fontspec = TRUE)}.
\item Bugfix: \code{add_rownames = "string"} now works as promised.
\item Bugfix: non-ASCII characters are now supported in RTF.
}
}

\subsection{Other news}{
\itemize{
\item New versions of the
\href{https://cran.r-project.org/package=gtsummary}{gtsummary} package will
have an \code{as_huxtable()} method.
\item Package \href{https://cran.r-project.org/package=texreg}{texreg} on CRAN
includes a \code{huxtablereg()} function for creating a table of regression
outputs.
}
}
}

\section{huxtable 4.7.1}{
\itemize{
\item The \href{https://github.com/gdemin/expss}{expss} package now supports
export to huxtables.
\item \code{by_quantiles()}, \code{by_equal_groups()} and \code{by_colorspace()} have
gained a \code{colwise} argument, which calculates quantiles or colors
separately for each column.
\item Add caption support for \code{as_flextable()} (thanks @sjewo).
}
}

\section{huxtable 4.7.0}{
\itemize{
\item Better error messages.
\item New \code{merge_repeated_rows()} function: merge repeated rows into a
single cell.
\item New \code{fill} and \code{colspan/rowspan} arguments for
\code{insert_row()/insert_column()}:
\itemize{
\item \code{insert_row(ht, "blah", "", "", "", "", ...)} can be written
\code{insert_row(ht, "blah", fill = "")}.
\item \code{colspan/rowspan} set \code{colspan/rowspan} of the first cell in the
inserted row/column.
}
}
}

\section{huxtable 4.6.1}{
\itemize{
\item Bugfix: right borders in wrong place when cells were merged.
\item Bugfix: chinese characters were displaying wrongly in \code{to_screen()}.
}
}

\section{huxtable 4.6.0}{
\itemize{
\item Set \code{options('huxtable.latex_use_fontspec')} to \code{TRUE} to use portable
font names in TeX documents, with the LaTeX “fontspec” package.
\item Bugfix: attributes were being copied wrongly in subset assignment of
huxtables.
\item Bugfix: text colors in \code{hux_logo()}.
\item Bugfix: rbind of huxtable and matrix wasn’t setting \code{row_height}
correctly.
}
}

\section{huxtable 4.5.0}{
\itemize{
\item Add \code{quick_latex()} function.
\item The \code{texreg} package now includes a \code{huxtablereg} function, analogous
to \code{huxreg}, which outputs a huxtable from a list of regressions. This
will be available from the next version of \code{texreg}.
}
}

\section{huxtable 4.4.0}{
\itemize{
\item Huxtables can now be printed directly in Word documents and Powerpoint
presentations, thanks to the \code{flextable} package and recent versions
of Pandoc. (Powerpoint printing requires Pandoc >= 2.4.0.)
\item New “wrapleft” and “wrapright” options to \code{position()} allow text
wrapping around tables.
\item New \code{set_outer_border_colors()} and \code{set_outer_border_styles()}
functions, like \code{set_outer_borders()}.
\item Huxtable no longer requires the \code{broom} package, instead using the
\code{generics} package. If you use \code{huxreg()}, you will still need
e.g. \code{broom} or \code{broom.mixed} to provide \code{tidy()} and \code{glance()}
methods for specific models.
\item Bugfix: \code{tidy.tidy_override()} and \code{glance.tidy_override()} should
work even if underlying object has no \code{tidy()} or \code{glance()} method.
\item Bugfix: huxtables had option clash when \code{echo = TRUE} in Rmd
pdf_document format.
\item Bugfix: \code{caption()} and \code{height()} weren’t playing nicely.
\item Bugfix: \code{mutate(..., copy_cell_props = FALSE)} was adding a column
named \code{copy_cell_props}.
\item Bugfix: \code{check_latex_dependencies} and \code{install_latex_dependencies}
gave misleading errors.
\item Enhancement: when \code{stars} is \code{NULL} in \code{huxreg}, don’t print a note by
default.
\item Enhancement: use \code{tinytex} when available, allowing autoinstallation
of latex packages.
}
}

\section{huxtable 4.3.0}{
\itemize{
\item More work on TeX. Tables \emph{should} now compile when raw_attributes is
not set.
\item New \code{map_xxx} functions to set properties variably by cell values.
\item Functions for mapping properties variably: \code{by_rows}, \code{by_values},
\code{by_ranges}, \code{by_quantiles} etc.
\item Correct bookdown labels are now automatically created.
\item New grey, blue, green and orange themes.
\item New “themes” vignette.
\item New \code{tidy_override} function to override p values etc. in \code{huxreg}.
\item New \code{set_contents} function to change huxtable contents within dplyr
pipes.
\item Enhancement: left- and right-aligned captions are now set above the
table in LaTeX, using the “threeparttable” package. You will need to
install this using e.g. \code{install_latex_dependencies()} or \code{tlmgr} if
it is not already on your system.
\item Enhancement: in \code{huxtable()} and friends, \code{add_rownames = "Colname"}
now sets the name for the new column.
\item Improvements to the vignettes and help files.
\item Bugfix: to_md could hang with bold/italic cells.
}
\subsection{Deprecated}{
\itemize{
\item The 3 argument form of \code{set_xxx} functions is deprecated, as is the
\code{where} function. Use \code{map_xxx} instead.
\item Argument \code{byrow} is soft-deprecated. Use \code{by_cols()} instead.
}
}
}

\section{huxtable 4.2.1}{
\itemize{
\item Bugfix: \code{wrap=TRUE} caused squeezed text in RTF.
}
\subsection{Important}{
\itemize{
\item TeX code was getting escaped by pandoc. To avoid this, if possible,
huxtable now adds fenced code blocks round latex tables (see
\url{https://pandoc.org/MANUAL.html#extension-raw_attribute}). You must
add

md_extensions: +raw_attribute

to your YAML header for this to work, and you will need a recent (>
2.0.0) version of Pandoc.
}
}
}

\section{huxtable 4.2.0}{
\itemize{
\item More speedups: LaTeX 2-3x faster, as_Workbook 2-3x faster.
\item Simplify LaTeX output using our own LaTeX commands.
\item RTF support: new \code{print_rtf}, \code{to_rtf} and \code{quick_rtf} functions.
\item New \code{border_style} properties to set “solid”, “double”, “dotted” or
“dashed” borders. (At present, LaTeX only allows “solid” or “double”.)
\item New \code{merge_cells} function, an alternative interface to \code{colspan} and
\code{rowspan}.
\item New \code{quick_pptx} function to print data frames and huxtables into
Powerpoint.
\item New \code{install_latex_dependencies} and \code{check_latex_dependencies}
utility functions.
\item \code{add_rows} and \code{add_columns} now accept data frames as arguments.
\item New \code{theme_mondrian} theme :-D
\item Enhancement: \code{print_md} now handles \strong{bold} and \emph{italic} cells.
\item Enhancement: \code{quick_pdf} has new \code{width} and \code{height} options to
change paper size.
\item Use CSS writing-mode where possible for text rotation. Note that this
may break on non-LTR languages. If this affects you, please file an
issue.
\item Bugfix: LaTeX didn’t compile when height and caption were both set.
\item Bugfix: \code{print_screen} and \code{print_md} would hang with a wide huxtable.
\item Tweaks to documentation.
}
}

\section{huxtable 4.1.0}{
\itemize{
\item dplyr, knitr, rmarkdown and some other packages have moved to
“Suggests:”, lowering the dependency load considerably. All the
functionality is still present. huxtable gives an informative warning
if a needed package is not installed.
\item Code rewrites for better performance and maintainability: HTML is up
to 10x faster, LaTeX is up to 4x faster.
\item Documentation improvements.
\item New \code{tribble_hux} function wrapping \code{tibble::tribble()} for readable
data input.
\item New \code{add_rows} and \code{add_columns} functions to insert one or more rows
into the middle of a huxtable.
\item New option “huxtable.knitr_output_format” to override the default
output format in knitr documents.
\item Numeric row heights and column widths are rescaled to 1 when huxtables
are cbinded/rbinded.
\item LaTeX: at points where borders cross, priority is given to the
horizontal border color.
\item Bugfix: property accessors had the wrong environment. Thanks to Iñaki
Úcar.
\item Bugfix: row heights and column widths weren’t being copied with
cbind/rbind.
\item Bugfixes for 0-row or 0-column huxtables:
\itemize{
\item Output works, usually with a warning.
\item cbind and rbind work.
}
\item Bugfix: HTML cols were printed with ‘width: NA’.
\item Bugfix: width, col_width etc. can be reset to a number after setting
them to a string.
\itemize{
\item The (undocumented) ability to mix numeric and non-numeric values for
padding and/border widths has been removed. If you want a number,
set a number and not a string.
}
\item Bugfix: HTML tables with position “right” weren’t right-aligned.
\item Nicer error messages when rbinding objects with different numbers of
rows.
\item Vignette improvements.
\item \code{is_a_number} is deprecated.
\item … and a cool new randomized \code{hux_logo()} ;-)
}
}

\section{huxtable 4.0.1}{
\itemize{
\item Improved formatting in Excel output.
\item New \code{format} method which returns the result of \code{to_html}, \code{to_latex}
etc. as appropriate.
\item Bugfix: \code{to_html} printing e.g. “left-border: NA;” in cell CSS.
\item Bugfix: \verb{set_all_*} not working when huxtable is not attached.
\item Bugfix: \code{as_Workbook} failing with non-numeric \code{width}.
\item Bugfix: \code{hux_logo} was using multiple fonts, fails with Excel output.
\item Bugfix: \code{as_flextable} borders not working in cells with colspan > 1.
\item Documentation bugfixes.
\item Compatibility with broom 5.0.0 - thanks @alexpghayes
}
}

\section{huxtable 4.0.0}{
\itemize{
\item New \code{theme_plain} theme.
\item The default value for \code{add_colnames} is going to become \code{TRUE}. At
present it remains \code{FALSE}. Set \code{options("huxtable.add_colnames")} to
\code{TRUE} or \code{FALSE} to set the default and avoid warnings in future.
\item \verb{quick_*} functions now automatically open documents if used
interactively. Use \code{open = FALSE} to avoid.
\item Tweak top and bottom margins for HTML tables.
\item \code{pad_decimal} is deprecated in favour of \code{align(ht) <- "."}.
\item \code{huxreg} continues with a warning if \code{statistics} are unavailable for
some models.
}
\subsection{Breaking changes}{
\itemize{
\item huxtable now provides \code{knit_print.data.frame} methods. This means that
bare data frames will be pretty-printed via huxtable if the package is
loaded.
\itemize{
\item Set \code{options("huxtable.knit_print_df")} to \code{FALSE} if you don’t want
this.
\item By default data frames are printed using the \code{theme_plain} theme.
Set options(“huxtable.knit_print_df_theme”) to a different
one-argument function if you want to use a different theme.
}
\item The new \code{autoformat} argument lets \code{huxtable()} and \code{as_huxtable()}
automatically choose alignment and number format based on column type.
Set \code{options("huxtable.autoformat")} to \code{FALSE} to turn off this
feature by default.
\item The default value of \code{number_format} has changed from “\%5.3g” to
“\%.3g”, which no longer space-pads numbers.
\item \code{as_flextable} now does not print column names in the header. This
matches the standard huxtable behaviour whereby headers are “just
another row/column”. To get the old behaviour, use
\code{colnames_to_header = TRUE}.
}
}

\subsection{Bugfixes}{
\itemize{
\item Bugfix: Date and datetime columns were converted to numbers by
\code{add_colnames}.
\item LaTeX bugfix: background colors were printing an extra space.
\item \code{huxreg} was never using built-in confidence intervals.
\item Screen bugfixes:
\itemize{
\item set max_width to screen width (thanks @jacob-long)
\item misaligned decimal points
}
\item Various bugfixes for \code{number_format}, \code{huxreg}, \code{as_hux.table},
\code{as_flextable}.
}
}
}

\section{huxtable 3.0.0}{
\itemize{
\item Output to Excel workbooks using the \code{openxlsx} package.
\item New \code{quick_xlsx} function.
\item dplyr select helpers now work inside \verb{set_*} column specifications:
e.g. set_bold(ht, 1:3, matches(“ab”), TRUE)
\item Column names can now be used for the \code{after} argument to
\code{insert_column}.
\item \verb{quick_*} functions: when the \code{file} argument is not explicitly
specified, confirm overwrites manually, or fail if called
non-interactively.
\item Add pointless quote marks in Description and Title… I don’t make the
rules.
\item Don’t apply number_format to negative exponents (e.g. 1.12e-3).
\item New \code{tidy_args} argument to huxreg allows per-model customization of
the call to \code{tidy}.
}
\subsection{Breaking changes}{
\itemize{
\item \code{quick_xxx} functions without an explicit \code{file} argument throw an
error if called non-interactively, and prompt before overwriting files
if called interactively.
}
}
}

\section{huxtable 2.0.2}{
\itemize{
\item Don’t apply \code{number_format} to exponents in scientific notation.
\item Turn off some tests on CRAN, as they fail there but not elsewhere.
}
}

\section{huxtable 2.0.1}{
\itemize{
\item Fix \code{quick_pdf} error when moving output across filesystems.
}
}

\section{huxtable 2.0.0}{
\itemize{
\item New \code{quick_html}, \code{quick_pdf} and \code{quick_docx} functions to print
table-like objects to a new document.
\item \code{to_screen} only shows colnames if there are any non-zero-length
column names.
}
\subsection{Breaking changes}{
\itemize{
\item \code{number_format} now applies to any number-like substrings in cells.
This means you can include e.g. significance stars in a cell and still
use \code{number_format} to format the content.
\item If \code{number_format} is NA, numbers are unchanged.
\item Default value of \code{number_format} has changed from “\%5.2f” to “\%5.3g”,
which plays nicer with integers but may surprise you by using
scientific format for large numbers.
}
}
}

\section{huxtable 1.2.0}{
\itemize{
\item New \code{outer_borders} argument for \code{huxreg}. This changes default
behaviour slightly.
\item New \code{border} argument for \code{add_footnote} to choose width of footnote’s
top border.
\item Added guard assertions to many exported functions.
\item Bugfix: captions and colnames are wrapped in to_screen to respect
max_width.
}
}

\section{huxtable 1.1.0}{
\itemize{
\item No more ugly autocreated column names.
\item Allow huxtable to have invalid or empty column names in general.
\item LaTeX should now be \emph{much} faster on large tables.
\item \code{set_outer_borders} now accepts the same row/column arguments as other
\code{set_} functions.
\item Better handling in LaTeX of horizontal borders which don’t cross the
entire table. (But not varying positive border widths….)
\item Bugfix: flextable didn’t like huxreg’s syntactically invalid column
names.
\item Accept, but silently change, English spelling of ‘centre’ in \code{align},
\code{position} and \code{caption_pos}.
}
}

\section{huxtable 1.0.0}{
\itemize{
\item LaTeX implements different thicknesses for vertical and horizontal
borders (but only one horizontal thickness per row).
\item LaTeX border colors now collapse nicely: set colors override unset
ones.
\item React gracefully to lack of p values in \code{huxreg}.
\item New \code{set_outer_borders} function to set borders round a rectangle of
cells.
\item \code{to_screen} and \code{to_md} now respect \code{wrap} and \code{col_widths}
properties.
\item Screen and markdown wrap respect word boundaries.
\item \code{to_screen} and \code{to_md} gain a \code{min_width} argument; \code{to_md} gains a
logical \code{header} argument; \code{to_screen} gains a \code{compact} argument
replacing \code{blank = NULL}.
\item On screen colour and bold support, if the \code{crayon} package is
installed. New \code{huxtable.color_screen} option.
\item Move from \code{ReporteRs} to \code{officer} and \code{flextable}. No more \code{RJava}
horror.
\item New \code{error_format} argument to \code{huxreg} for flexible control over
uncertainty estimates.
\item Infrastructure improvements: slightly less ugly code in screen.R and
LaTeX.R.
}
\subsection{Breaking changes}{
\itemize{
\item Removed options \code{collapse}, \code{borders}, \code{blank} and \code{colname_color}
from \code{to_screen}/\code{print_screen}.
\item \code{as_FlexTable} is deprecated and calls \code{as_flextable} with a warning.
\code{header_rows} and \code{footer_rows} arguments are ignored. If you need
this feature, tell me.
\item HTML border sizes are now set in points, not pixels.
\item In \code{huxreg}:
\itemize{
\item \code{ci_level} is \code{NULL} by default. Set it to a number to calculate
confidence intervals.
\item \code{error_style} is deprecated with a warning in favour of
\code{error_format}.
\item Use \code{{stars}} not \verb{\%stars\%} to display significance levels in the
\code{note} argument.
\item \code{borders} becomes a number specifying border width. Set to 0 for no
borders.
}
}
}
}

\section{huxtable 0.3.1}{
\itemize{
\item New convenience functions \code{insert_row} and \code{insert_column}.
\item \code{latex_float} property allows you to change positioning in LaTeX.
\item (Semantic versioning fail: this should have been 0.4.0.)
}
}

\section{huxtable 0.3.0}{
\itemize{
\item New borders argument for huxreg, gives borders in sensible places.
\item Allow more flexible caption positioning with \code{caption_pos}.
\item New \code{set_default_properties} function to set default properties for
new huxtables.
\item Fix compatibility with dplyr 0.6.0.
}
}

\section{huxtable 0.2.2}{
\itemize{
\item Fix a bug that could lead to wrong significance stars in \code{huxreg}.
}
}

\section{huxtable 0.2.1}{
\itemize{
\item Compatibility with dplyr 0.6.0.
\item Use ~ for decimal padding in LaTeX.
}
}

\section{huxtable 0.2.0}{
\itemize{
\item New \code{huxreg} function to convert a list of models to a huxtable.
\item New set_* interface allowing column ranges, expressions a la
\code{subset}, and filling in values by row.
\item Replacement methods \verb{$<-}, \verb{[<-} and \verb{[[<-} now work better.
\item New function \code{set_cell_properties} to set multiple properties on
cells.
\item \code{evens}, \code{odds}, \code{everywhere}, \code{every(n, from)}, \code{final(n)},
\code{where(cond)}: convenience functions to select rows, columns and
cells.
\item Export to Word/Powerpoint via \code{ReporteRs}.
\item Huxtable now supports dplyr verbs like \code{filter} and \code{select}.
\item Exported function \code{guess_knitr_output_format}.
\item Ability to set border colors.
\item Prevent overlapping row/colspans.
\item Expanded introduction and new vignette for \code{huxreg}.
\item Numerous bugs have been fixed and replaced with new, more advanced
bugs.
}
\subsection{Breaking changes}{
\itemize{
\item \code{theme_minimal} has been renamed \code{theme_basic} to avoid a name clash
with \code{ggplot2}.
}
}
}

\section{huxtable 0.1.0}{
\itemize{
\item Added a \code{NEWS.md} file to track changes to the package.
\item First CRAN release.
}
}

