% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{rowspan}
\alias{rowspan}
\alias{rowspan<-}
\alias{set_rowspan}
\alias{rowspan.huxtable}
\alias{rowspan<-.huxtable}
\title{Row span}
\usage{
rowspan(ht)
rowspan(ht) <- value
set_rowspan(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{An integer vector or matrix of integers. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{rowspan}, the \code{rowspan} attribute.
For \code{set_rowspan}, the \code{ht} object.
}
\description{
Functions to get or set the row span property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
rowspan(ht)[1, 1] <-  2
rowspan(ht)
print_screen(ht)
}
