% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{number_format}
\alias{number_format}
\alias{number_format<-}
\alias{set_number_format}
\alias{number_format.huxtable}
\alias{number_format<-.huxtable}
\title{Number format}
\usage{
number_format(ht)
number_format(ht) <- value
set_number_format(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or list which may be character, numeric or function. See below. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{number_format}, the \code{number_format} attribute.
For \code{set_number_format}, the \code{ht} object.
}
\description{
Functions to get or set the number format property of huxtable table cells.
}
\details{
Number formatting is applied to any parts of cells that look like numbers (defined as an optional minus sign,
followed by
numerals, followed by an optional decimal point and further numerals). If \code{value} is numeric,
numbers will be rounded to that many decimal places.  If \code{value} is
character, it will be taken as an argument to \code{\link{sprintf}}. If \code{value} is a
function it will be applied to the numbers and should return a string. If \code{value} is \code{NA}, then numbers
will be unchanged.

The default value is "%5.3g" which rounds numbers if they have more than 3 significant
digits, and which may use an exponent for large numbers.

To set number_format to a function, enclose the function in \code{list}.
See the examples.

Versions of huxtable before 2.0.0 applied \code{number_format} only to cells that looked like
numbers in their entirety. The default value was "%5.2f".
}
\examples{
ht <- huxtable(a = 10^(3:6) + (5 * 10^(-2:-5)), b = 10^(3:6) + (5* 10^(-2:-5)))
number_format(ht)[1,] <- 2
number_format(ht)[2,] <- '\%5.2f'
number_format(ht)[3,] <- list(function(x) prettyNum(x, big.mark = ','))
number_format(ht)[4,] <- list(function(x) if(x>0) '+' else '-')
ht
print_screen(ht)
ht_bands <- huxtable("10000 Maniacs")
ht_bands # probably not what you want
number_format(ht_bands) <- NA
ht_bands

ht <- huxtable(a = 1:3, b = 3:1)
ht2 <- set_number_format(ht, 2)
number_format(ht2)
ht3 <- set_number_format(ht, 1:2, 1, 2)
number_format(ht3)
ht4 <- set_number_format(ht, 1:2, 1:2, c(2, 3), byrow = TRUE)
number_format(ht4)
ht5 <- set_number_format(ht, where(ht == 1), 2)
number_format(ht5)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{text_color}}
}
