% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_bearing.R
\name{average_bearing}
\alias{average_bearing}
\alias{average_bearing_n}
\title{Average of bearings}
\usage{
average_bearing(theta1, theta2, average_of_opposite = NULL)

average_bearing_n(thetas)
}
\arguments{
\item{theta1, theta2}{Bearings, expressed in degrees.}

\item{average_of_opposite}{The average of opposing bearings (e.g. average of north
and south) is not well-defined. If \code{NULL}, the result for opposing vectors is 
undefined; if \code{"right"}, returns 
\code{theta1 + 90}; if \code{"left"} then \code{theta2 + 90}. Can also be 
a single numeric to provide a specific value when the vectors point in opposite 
directions.}

\item{thetas}{A vector of bearings.}
}
\value{
For `average_bearing`, the bearing bisecting the two bearings.

For `average_bearing_n`, the average bearing of the bearing.
}
\description{
Average of bearings
}
\examples{
average_bearing(0, 90)
average_bearing(0, 270)
average_bearing(90, 180)

average_bearing(0, 180)
average_bearing(0, 180, average_of_opposite = 3)
average_bearing(0, 180, average_of_opposite = "left")

average_bearing_n(1:179)

}
