% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{set.chr.to.numeric}
\alias{set.chr.to.numeric}
\title{Change the chromosome labels in a RangedData or GRanges object to numbers}
\usage{
set.chr.to.numeric(ranged, keep = T, table.in = NULL, table.out = FALSE)
}
\arguments{
\item{ranged}{A GRanges or RangedData object}

\item{keep}{logical, whether to keep additional metadata columns in the new object}

\item{table.in}{matrix/data.frame object, usually a result of a prior run of 
set.chr.to.numeric(table.out=TRUE), which shows for each label (column 1), what
chromosome number should correspond. A way of ensuring consistent coding in different
sets.}

\item{table.out}{logical, if FALSE, the output will just be the object with updated 
chromosome labels. If TRUE, then the output will be a list, where the first element
is the updated object and the second object is a table describing the coding
scheme used to convert from labels to numeric indices.}
}
\value{
returns the 'ranged' object, but wherever a chromosome label was previously a character
label, e.g, 'chr1', or 'X', will return as a number, e.g, 1 or 23 respectively. If table.out
is TRUE will return a list where the first element is the resulting object, and the second 
element is a table showing which labels were converted to what number. This table
can then be used for future conversions via the parameter 'table.in' to ensure consistency of
coding.
}
\description{
Change the chromosome labels in a RangedData or GRanges object to numbers
}
\examples{
char <- rranges(chr.pref=TRUE)
char
set.chr.to.numeric(char)
# behaviour with X, Y, etc
char <- rranges(chr.range=c(20:26))
#' char
set.chr.to.numeric(char)
tab <- set.chr.to.numeric(char,table.out=TRUE)[[2]]
tab # codes used in conversion #
char <- rranges(chr.range=c(20:26))
set.chr.to.numeric(char, table.in=tab) # code using codes from 'tab'
}
\seealso{
\code{\link{set.chr.to.char}}
}
