% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{compact.gene.list}
\alias{compact.gene.list}
\title{Make a compact version of gene annotation}
\usage{
compact.gene.list(x, n = 3, sep = ";", others = FALSE)
}
\arguments{
\item{x}{is a character vector of gene label listings, where multiple hits
are delimited by 'sep'}

\item{n}{number of genes to list before abbreviating}

\item{sep}{character, separator used to delimit genes in elements of x}

\item{others}{logical, TRUE to abbreviate with '+ # others' or FALSE to
append just the number of genes not listed.}
}
\value{
a character vector with the form:
gene-1, gene-2, ..., gene-n, + length(gene-n) - n [others]
}
\description{
When adding gene annotation to genomic ranges, sometimes
there are many genes associated with a single feature, so
that compiling a table becomes awkward, if some rows contain
hundreds of genes. This function takes a character vector
of gene lists delimited by some separator and provides
a compact representation of the gene labels
}
\examples{
my.genes <- c("ERAP1","HLA-C;CTLA4;IFIH","INS;MYC","AGAP1;APOE;DRDB1;FUT2;HCP5;BDNF;COMT")
compact.gene.list(my.genes)
compact.gene.list(my.genes,n=2,others=TRUE)
}

