% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.chr.lens}
\alias{get.chr.lens}
\title{Get chromosome lengths from build database}
\usage{
get.chr.lens(dir = NULL, build = NULL, autosomes = FALSE,
  len.fn = "humanChrLens.txt", mito = FALSE, names = FALSE,
  delete.after = FALSE, verbose = FALSE)
}
\arguments{
\item{dir}{directory to retrieve/download the annotation from/to (defaults to current getwd())
if dir is NULL then will automatically delete the annotation text file from the local directory
 after downloading}

\item{build}{string, currently 'hg17','hg18' or 'hg19' to specify which annotation version to use. 
Default is getOption("ucsc"). Will also accept integers 17,18,19,35,36,37 as alternative arguments.}

\item{autosomes}{logical, if TRUE, only load the lengths for the 22 autosomes, else load X,Y,[MT] as well}

\item{len.fn}{optional file name to keep the lengths in}

\item{mito}{logical, whether to include the length of the mitochondrial DNA (will not include unless
autosomes is also FALSE)}

\item{names}{logical, whether to name the chromosomes in the resulting vector}

\item{delete.after}{logical, if TRUE then delete the text file that these lengths were downloaded to.}

\item{verbose}{logical, if TRUE display extra information on progress of chromsome retrieval
If FALSE, then the file will be kept, meaning future lookups will be faster, and available offline.}
}
\description{
Quick and easy way to retrieve human chromosome lengths. Can select from hg18/hg19 (ie, 
 build 36/37), or any future builds (hg20, etc) stored in the same location on the build website.
 Default is to return lengths for 22 autosomes, but can also retrieve X,Y 
 and Mitochondrial DNA lengths by 'autosomes=FALSE' or n=1:25. Even if not connected to 
 the internet can retrieve hard coded lengths for hg18 or hg19.
}
\examples{
 setwd(tempdir())
 get.chr.lens(delete.after=TRUE) # delete.after simply deletes the downloaded txt file after reading
 get.chr.lens(build=35,autosomes=TRUE,delete.after=TRUE) # only for autosomes
 get.chr.lens(build="hg19",mito=TRUE,delete.after=TRUE) # include mitochondrial DNA length
}

