% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-headers.R
\name{req_headers}
\alias{req_headers}
\title{Modify request headers}
\usage{
req_headers(.req, ...)
}
\arguments{
\item{.req}{A \link{request}.}

\item{...}{Name-value pairs of headers and their values.
\itemize{
\item Use \code{NULL} to reset a value to httr's default
\item Use \code{""} to remove a header
\item Use a character vector to repeat a header.
}}
}
\value{
A modified HTTP \link{request}.
}
\description{
\code{req_headers()} allows you to set the value of any header.
}
\examples{
req <- request("http://example.com")

# Use req_headers() to add arbitrary additional headers to the request
req \%>\%
  req_headers(MyHeader = "MyValue") \%>\%
  req_dry_run()

# Repeated use overrides the previous value:
req \%>\%
  req_headers(MyHeader = "Old value") \%>\%
  req_headers(MyHeader = "New value") \%>\%
  req_dry_run()

# Setting Accept to NULL uses curl's default:
req \%>\%
  req_headers(Accept = NULL) \%>\%
  req_dry_run()

# Setting it to "" removes it:
req \%>\%
  req_headers(Accept = "") \%>\%
  req_dry_run()

# If you need to repeat a header, provide a vector of values
# (this is rarely needed, but is important in a handful of cases)
req \%>\%
  req_headers(HeaderName = c("Value 1", "Value 2", "Value 3")) \%>\%
  req_dry_run()
}
