% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/oauth-token.r
\name{oauth2.0_token}
\alias{oauth2.0_token}
\title{Generate an oauth2.0 token.}
\usage{
oauth2.0_token(endpoint, app, scope = NULL, type = NULL,
  use_oob = getOption("httr_oob_default"), as_header = TRUE,
  cache = getOption("httr_oauth_cache"))
}
\arguments{
\item{endpoint}{An OAuth endpoint, created by \code{\link{oauth_endpoint}}}

\item{app}{An OAuth consumer application, created by
\code{\link{oauth_app}}}

\item{scope}{a character vector of scopes to request.}

\item{type}{content type used to override incorrect server response}

\item{use_oob}{if FALSE, use a local webserver for the OAuth dance.
Otherwise, provide a URL to the user and prompt for a validation
code. Defaults to the of the \code{"httr_oob_default"} default,
or \code{TRUE} if \code{httpuv} is not installed.}

\item{as_header}{If \code{TRUE}, the default, sends oauth in bearer header.
If \code{FALSE}, adds as parameter to url.}

\item{cache}{A logical value or a string. \code{TRUE} means to cache
using the default cache file \code{.oauth-httr}, \code{FALSE} means
don't cache, and \code{NA} means to guess using some sensible heuristics.
A string mean use the specified path as the cache file.}
}
\value{
A \code{Token2.0} reference class (RC) object.
}
\description{
This is the final object in the OAuth dance - it encapsulates the app,
the endpoint, other parameters and the received credentials. It is a
reference class so that it can be seamlessly updated (e.g. using
\code{$refresh()}) when access expires.
}
\details{
See \code{\link{Token}} for full details about the token object, and the
caching policies used to store credentials across sessions.
}
\seealso{
Other OAuth: \code{\link{oauth1.0_token}};
  \code{\link{oauth_app}}; \code{\link{oauth_endpoint}};
  \code{\link{oauth_service_token}}
}

