% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-paths.R
\name{.mockPaths}
\alias{.mockPaths}
\title{Set an alternate directory for mock API fixtures}
\usage{
.mockPaths(new)
}
\arguments{
\item{new}{Either a character vector of path(s) to add, or \code{NULL} to reset
to the default.}
}
\value{
If \code{new} is omitted, the function returns the current search paths, a
a character vector. If \code{new} is provided, the updated value will be returned
invisibly.
}
\description{
By default, \code{with_mock_api} will look for mocks relative to the current
working directory (the test directory). If you want to look in other places,
you can call \code{.mockPaths} to add directories to the search path.
}
\details{
It works like \code{\link[base:.libPaths]{base::.libPaths()}}: any directories you specify will be added
to the list and searched first. The default directory will be searched last.
Only unique values are kept: if you provide a path that is already found in
\code{.mockPaths}, the result effectively moves that path to the first position.

For finer-grained control, or to completely override the default behavior
of searching in the current working directory, you can set the option
"httptest.mock.paths" directly.
}
\examples{
identical(.mockPaths(), ".")
.mockPaths("/var/somewhere/else")
identical(.mockPaths(), c("/var/somewhere/else", "."))
.mockPaths(NULL)
identical(.mockPaths(), ".")
}
