% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake-http.R
\name{fakeResponse}
\alias{fakeResponse}
\alias{fakeDownload}
\title{Return something that looks enough like an httr 'response'}
\usage{
fakeResponse(url = "", verb = "GET", status_code = 200,
  headers = list(), content = NULL)

fakeDownload(url, destfile, ...)
}
\arguments{
\item{url}{A character URL for the request. For \code{fakeDownload}, this
should be a path to a file that exists.}

\item{verb}{Character name for the HTTP verb. Default is "GET"}

\item{status_code}{Integer HTTP response status}

\item{headers}{Optional list of additional response headers to return}

\item{content}{If supplied, a JSON-serializable list that will be returned
as response content with Content-Type: application/json. If no \code{content}
is provided, and if the \code{status_code} is not 204 No Content, the
\code{url} will be set as the response content with Content-Type: text/plain.}

\item{destfile}{For \code{fakeDownload}, character file path to "download"
to. \code{fakeDownload} will copy the file at \code{url} to this path.}

\item{...}{Additional arguments for \code{fakeDownload}}
}
\value{
The fake verbs return a 'httr' response class object.
\code{fakeDownload} returns 0, the success code returned by
\code{\link[utils:download.file]{utils::download.file()}}.
}
\description{
These functions allow mocking of HTTP requests without requiring an internet
connection or server to run against. Their return shape is a 'httr'
"response" class object that should behave like a real response generated
by a real request.
}
