% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_timestep.R
\name{h_timestep}
\alias{h_timestep}
\title{Infra-daily fixed timestep}
\usage{
h_timestep(file, tst, op = "M")
}
\arguments{
\item{file}{Instantaneous time-series}

\item{tst}{Timestep in minutes - must be a divisor of 1440 between 10 and 1440}

\item{op}{: "S", "M" (default), "Mn" ou "Mx"}
}
\value{
A hts time-series file with a fixed timestep. The duration of the time-step
in minutes is added to the file name.
}
\description{
Computes a time-series with a fixed infra-daily timestep starting from an instantaneous time-series
- possible option: sum, mean, max or min
}
\details{
The op parameter give precise the chosen computation method within the interval: sum ("S"), la
mean ("M"), minimum ("Mn") or maximum ("Mx").
}
\examples{
\dontrun{

f <- t_timestep(f, tst, op="S")
}


}
\author{
P. Chevallier - Oct 2017 - Dec 2018
}
