% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_sensor.R
\name{d_sensor}
\alias{d_sensor}
\title{Create, Modify or Remove a sensor}
\usage{
d_sensor(
  db.sqlite,
  op = "C",
  sta,
  sen,
  table = NA,
  name_fld = NA,
  value_fld = NA,
  bku = TRUE
)
}
\arguments{
\item{db.sqlite}{Full name of the data base}

\item{op}{Create, modify or remove C/M/R}

\item{sta}{station id}

\item{sen}{sensor id}

\item{table}{table of the sensor}

\item{name_fld}{list of field names}

\item{value_fld}{list of field values}

\item{bku}{Automatic Backup TRUE (default) / FALSE}
}
\value{
Sensor created, modified ou removed from the data base
}
\description{
Create, Modify or Remove a sensor
}
\details{
If op is C, the fields sta, table and
sen are compulsory and cannot be modified afterwards.

Allowed entries for table are: WL (water levels), DI (discharges),
QU (Quality), PR (precipitations), WE (weather).

If op is C or M, the following fields can be completed :
Nature= as.character(NA), Description = as.character(NA),
Commentaire= as.character(NA), Code_Limni= as.character(NA),
Principal = as.logical(NA), Fictif = as.logical(NA),
Maj_Journaliers = as.logical(NA), Maj_Traduction = as.logical(NA),
Acquisition_Auto = as.logical(NA), Operationnel = as.logical(NA),
Liste_Inst = as.character(NA), Liste_Jour = as.character(NA),
Liste_Mois = as.character(NA), Agregation = as.character(NA),
Decalage_Temps = as.numeric(NA), Mini = as.numeric(NA),
Maxi = as.numeric(NA), Gradient_Maxi = as.numeric(NA),
Precision = as.numeric(NA), Decimales = as.numeric(NA),
Pente = as.numeric(NA))

If op is R, all data corresponding to the sensor of the selected
station are removed.
}
\seealso{
\itemize{
 \item \code{\link{d_inventory}} or \code{\link{d_invent}} to explore the
 data base content;
 \item \code{\link{d_exphts}} to extract a time-series;
 \item \code{\link{d_create},\link{d_table}} to create a data base and/or create/remove
 a table ;
 \item \code{\link{d_station}} for create/remove a station.
}
}
\author{
P. Chevallier - Feb 2018-Jan 2019
}
