% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeDependencyRelative}
\alias{makeDependencyRelative}
\title{Make an absolute dependency relative}
\usage{
makeDependencyRelative(dependency, basepath, mustWork = TRUE)
}
\arguments{
\item{dependency}{A single HTML dependency with an absolute path.}

\item{basepath}{The path to the directory that \code{dependency} should be
made relative to.}

\item{mustWork}{If \code{TRUE} and \code{dependency} does not point to a
  directory on disk (but rather a URL location), an error is raised. If
  \code{FALSE} then non-disk dependencies are returned without modification.}
}
\value{
The dependency with its \code{src} value updated to the new
location's relative path.

If \code{baspath} did not appear to be a parent directory of the dependency's
directory, an error is raised (regardless of the value of \code{mustWork}).
}
\description{
Change a dependency's absolute path to be relative to one of its parent
directories.
}
\seealso{
\code{\link{copyDependencyToDir}}
}

