\name{hse}
\alias{hse}
\alias{dhse}
\alias{phse}
\alias{qhse}
\alias{rhse}
\title{
    The hse (\dQuote{Hope Springs Eternal}) distribution.
}
\description{
Density, distribution function, quantile function and random generation for the hse
distribution with parameters \code{alpha}, \code{beta} and \code{ntop}.
}
\usage{
dhse(i, alpha, beta, ntop, zeta=FALSE)
phse(x, alpha, beta, ntop, zeta=FALSE)
qhse(p, alpha, beta, ntop, zeta=FALSE)
rhse(n, alpha, beta, ntop, zeta=FALSE)
}
\arguments{
  \item{i}{
  Vector of integer values between 1 and \code{ntop} the probabilities
  of which are calculated by \code{dhse()}.  Missing values (\code{NA})
  are allowed.
}
  \item{x}{
  Numeric vector.  The cumulative distribution function of the
  hse distribution is evaluated at the entries of this vector by
  \code{phse}.  Note that the entries of \code{x} \emph{need not}
  be in the set \code{{1,2, ..., ntop}}.  Missing values (\code{NA})
  are allowed.
}
  \item{p}{
  Vector of probablilities (i.e. values between 0 and 1).  The
  corresponding quantiles of the hse distribution are calculated
  by \code{qhse()}.  Missing values (\code{NA}) are allowed.
}
  \item{n}{
  Integer scalar.  An independent sample of size \code{n} from the hse distribution
  is generated by \code{rhse()}.
}
  \item{alpha}{
  Non-negative scalar.  The first \dQuote{shape} parameter of the hse
  distribution.
}
  \item{beta}{
  Non-negative scalar.  The second \dQuote{shape} parameter of the hse
  distribution.
}
  \item{ntop}{
  Integer scalar, strictly greater than 1.  The number of possible
  values of the hse distribution.
}
  \item{zeta}{
  Logical scalar.  Should zero origin indexing be used?
  I.e. should the range of values of the distribution be taken to
  be \code{{0,1,2,...,ntop}} rather than \code{{1,2,...,ntop}}?
  Setting \code{zeroOrgin=TRUE} may be useful for example when
  the values of the distribution are to be interpreted as counts.
}
}

\details{
The probability function (i.e. \code{dhse()}) of the hse distribution
is given by \code{dhse(i,alpha,beta,ntop) = dbeta(i/(ntop+1),alpha,beta)/
sum(dbeta((nbot:ntop)/(ntop+k),alpha,beta))} where \code{nbot}
is 1 and \code{k} is 1 if \code{zeta} is \code{FALSE}
and \code{nbot} is 0 and \code{k} is 2 if \code{zeta}
is \code{TRUE}.

This is a probability function for an ad hoc finite discrete
distribution of \emph{ordered} values, with a \dQuote{reasonably
flexible} shape.

The \eqn{p}th quantile of a random variable \eqn{X} is defined to be
the infimum \emph{over the range of} \eqn{X} of those values of \eqn{x}
such that \eqn{F(x) \geq p}{F(x) >= p} where \eqn{F(x)} is the cumulative
distribution function for \eqn{X}.  Note that if we did not impose the
\dQuote{over the range of \eqn{X}} restriction, then the 0th quantile of
e.g. an exponential distribution would be \eqn{-\infty}{\code{-Inf}}
(since \eqn{F(x) \geq 0}{F(x) >= 0} for \emph{all} \eqn{x}) whereas we
actually want this quantile to be 0.

Consequently \code{qhse(p,alpha,beta,ntop)} is equal to the
least value of \code{i} such that \code{phse(i,alpha,beta,ntop)}
\eqn{\geq}{>=} \code{p}.  The set of values of \code{i} to be
considered is \code{{1,2,...,ntop}} if \code{zeta} is
\code{FALSE} and is \code{{0,1,2,...,ntop}} if \code{zeta}
is \code{TRUE}.

}
\value{
\itemize{
\item For \code{dhse()} and \code{phse()} vectors of probabilities.
\item For \code{qhse()} a vector of quantiles.
\item For \code{rhse()} a vector of length \code{n}, of integers
      between \code{nbot} and \code{ntop}, independently sampled
      from the hse distribution, where \code{nbot} is 1 if
      \code{zeta} is \code{FALSE} and is 0 if \code{zeta}
      is \code{TRUE}.
}
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}

\seealso{
   \code{\link{meHse}()}
   \code{\link{mleHse}()}
}
\examples{
parz <- list(c(0.5,0.5),c(5,1),c(1,3),c(2,2),c(2,5))
for(i in 1:5) {
    p1 <- dhse(1:15,parz[[i]][1],parz[[i]][2],15)
    names(p1) <- 1:15
    eckslab <- paste0("alpha=",parz[[i]][1]," beta=",parz[[i]][2])
    barplot(p1,xlab=eckslab,main="hse probabilities",
            space=1.5,col="black")
    abline(h=0)
    if(i < 5) readline("Go? ")
}
}
\keyword{ distribution }
