% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CovarMatrix}
\alias{CovarMatrix}
\title{CovarMatrix}
\usage{
CovarMatrix(exp_freq_mat, LDDam, LDSire, Ns)
}
\arguments{
\item{exp_freq_mat}{[MATRIX] paternal EXPECTATION matrix}

\item{LDDam}{[MATRIX] maternal Linkage Disequilibrium matrix}

\item{LDSire}{[LIST] Linkage disequilibrium matrices for the sires; each
element of the list corresponds to a family}

\item{Ns}{[VECTOR] family size for each sire s}
}
\value{
\describe{
  \item{\code{covK}}{(p x p) matrix of covariance between markers}
}
}
\description{
Calculation of covariance matrices from LD-matrices
}
\details{
The internal suMM function works on lists!
}
\examples{
 data(testdata)
 G <- Haplo2Geno(H.sire)
 E <- ExpectMat(G)
 LDfam2 <- LDsire(H.sire, pos.chr, family = 3:4)
 LDfam3 <- LDsire(H.sire, pos.chr, family = 5:6)
 ## covariance matrix based on sires 2 and 3 only, each with 100 progeny
 K <- CovarMatrix(E[2:3, ], LDDam = matLD, LDSire = list(LDfam2, LDfam3), Ns = c(100, 100))
}
