% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paillier.R
\docType{class}
\name{PaillierPublicKey}
\alias{PaillierPublicKey}
\title{Construct a Paillier public key with the given modulus.}
\format{An \code{\link{R6Class}} generator object}
\usage{
PaillierPublicKey
}
\description{
Construct a Paillier public key with the given modulus.
}
\section{Fields}{

\describe{
\item{\code{bits}}{the number of bits in the modulus}

\item{\code{n}}{the modulus}

\item{\code{nSquared}}{the square of the modulus}

\item{\code{nPlusOne}}{one more than the modulus}
}}
\section{Methods}{

\describe{
  \item{\code{PaillierPublicKey$new(bits, n)}}{Create a new public key with given \code{bits} and modulus
        \code{n}. It also precomputes a few values for more efficient computations}
  \item{\code{PaillierPublicKey$encrypt(m)}}{Encrypt a message. The value \code{m} should be less than
        the modulus, not checked}
  \item{\code{PaillierPublicKey$add(a, b)}}{Return the sum of two encrypted messages \code{a} and \code{b}}
  \item{\code{PaillierPublicKey$mult(a, b)}}{Return the product of two encrypted messages \code{a} and
             \code{b}}
}
}
\seealso{
\code{PaillierPrivateKey} which goes hand-in-hand with this object
}
\keyword{datasets}

