% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mplus_tsyn.R
\name{Mplus_tsyn}
\alias{Mplus_tsyn}
\title{Generating Mplus syntax for testing empirical RIASEC angular locations}
\usage{
Mplus_tsyn(
  N,
  Cor,
  name = NULL,
  test = "perfect",
  dummyvorl = 1,
  verbose = FALSE,
  eol = "\\r\\n",
  ...
)
}
\arguments{
\item{N}{number of observations for correlations as numeric}

\item{Cor}{either an R matrix object with RIASEC correlations or the name of a correlation matrix, stored as a .dat text file, as character (see details).}

\item{name}{optional a name (as character) for the Mplus syntax to be saved - default is the object name or the name given in parameter \code{Cor} as character (with ending changed to '.inp').}

\item{test}{either character (default test="perfect"), which tests against a perfect circumplex array, or a numeric vector with length = 6 giving the six angular locations (in radians) to test against.}

\item{dummyvorl}{default is dummyvorl = 1, which results in the Mplus syntax given in Nagy et. al. (2009). !! don't change this !!
if changed: \emph{"Alternativ dazu kann hier auch der Name einer zu verwendenden Dummyvorlage angegeben werden die dann eingelesen und verwendet wird. Es empfiehlt sich dringend die interne Syntaxvorlage zu verwenden - es sei den zum weiterentwickeln und Testen der Funktionen"}.}

\item{verbose}{logical with default set to \code{verbose=FALSE}; if set to \code{verbose=TRUE} the resulting Mplus syntax is \emph{additionally} printed on the console.}

\item{eol}{character see \code{\link{write.table}} to control the generation of correct line endings in text files on different operating systems.}

\item{...}{additional parameters passed through}
}
\value{
resulting Mplus syntax will be saved in the current working directory
}
\description{
This function generates executable Mplus syntax which is discussed in Nagy et. al. (2009). the resulting Mplus syntax estimates the fit of the empirical angular locations of the six RIASEC dimensions, found based on their correlations, in the assumed circumplex array within the theory of vocational choice by John Holland (1997).
}
\details{
more to come ...
}
\examples{
## generating an example Mplus syntax referring to a R object with correlation data 
data(example2) # loading fictional example correlation matrix
# generate and write Mplus input file in your workspace directory
Mplus_tsyn(N = 300, Cor = example2)
## Mplus syntax is now saved in the current workspace
################################################################
### clean up work directory
file.remove("example2.inp") # remove generated Mplus syntax from work dir.
file.remove("example2.dat") # remove generated cor. data from work dir.
}
\references{
Holland, J.L. (1997). \emph{Making vocational choices. A theory of vocational personalities and work environments}. Lutz, FL: Psychological Assessment Resources.

Nagy, G., Marsh, H. W., Luedtke, O., & Trautwein, U. (2009). Representing circles in our minds: Confirmatory factor analysis of circumplex structures and profiles. In T. Teo & M. S. Khine (Hrsg.), \emph{Structural Equation Modeling in Educational Research: Concepts and applications} (S. 287 - 315). Rotterdam Boston Taipei: Sense Publishers.
}
\keyword{calculus}
