% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-09-14.R
\name{decompose_interval}
\alias{decompose_interval}
\title{decompose up intervals}
\usage{
decompose_interval(interval)
}
\arguments{
\item{interval}{an \code{interval} object of length n
(if it is something else, it is returned unchanged)}
}
\value{
A data.frame with 5 columns.
1. A column "precise" for the precise observations
(length of interval = 0, e.g. "3000;3000"). If observation i is not precise,
the i-th entry in this columns will be \code{NA}.
c("2500;2500", "3000;4000", "-Inf;0", NA) will lead to c(2500, NA, NA, NA)
2. A column "lower" for the values of the lower bounds
of the imprecise observations (length of interval > 0,
e.g. "3000;4000" or "-Inf;0"), precise observations will get
\code{NA}s here.
c("2500;2500", "3000;4000", "-Inf;0", NA) will lead to c(NA, 3000, -Inf, NA)
3. A column "upper" for the values of the upper bounds
of the imprecise observations.
c("2500;2500", "3000;4000", "-Inf;0", NA) will lead to c(NA, 4000, 0, NA)
4. A column "lower_general" with the lower bound values of all observations,
without distinction between precise, imprecise or missing observations.
c("2500;2500", "3000;4000", "-Inf;0", NA) will lead to c(2500, 3000, -Inf, -Inf)
5. A column "upper_general" with the upper bound values of all observations.
c("2500;2500", "3000;4000", "-Inf;0", NA) will lead to c(2500, 4000, 0, Inf)
}
\description{
This function decomposes an interval object up into precise observations
(e.g. "1850.23;1850.23" into 1850.23),
imprecise observations (e.g. "1800;1900") and
missing observations ("-Inf;Inf" into NA)
}
