% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-haplotype.R
\name{ImputeHaplo}
\alias{ImputeHaplo}
\title{Imputation}
\usage{
ImputeHaplo(dat_in)
}
\arguments{
\item{dat_in}{A data frame with low resolution HLA data.}
}
\value{
A data frame with high resolution HLA data pulled from the most likely pair of haplotypes matching the input low resolution data.
}
\description{
Impute low or mixed resolution HLA(Human Leukocyte Antigen) typing to the most likely high resolution equivalent. Imputation is computationally intensive, so large dataset may encounter delays in processing. This function uses data from the NMDP(National Marrow Donor Program), and is currently limited to HLA A, B, C, and DRB loci.
}
\examples{
\donttest{
dat <- read.csv(system.file("extdata/example", "Haplotype_test.csv", package = "hlaR"))
result <- ImputeHaplo(dat_in = dat[c(1:2), ])
}
}
