% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrapol.return.level.R
\name{extrapol.return.level}
\alias{extrapol.return.level}
\title{Spatial extrapolation of a return level.}
\usage{
extrapol.return.level(period, fit, targets, targets.covariates)
}
\arguments{
\item{period}{An integer indicating the wished return period T.}

\item{fit}{Output from the \code{hkevp.fit} procedure.}

\item{targets}{A matrix of real values giving the spatial coordinates of the ungauged positions. Each row corresponds to an ungauged position.}

\item{targets.covariates}{A matrix of real values giving the spatial covariates of the ungauged positions. Must match with the covariates used in \code{\link{hkevp.fit}} or \code{\link{latent.fit}}.}
}
\value{
A matrix of predictive sample. Each column corresponds to a target position and each row to a predictive draw.
}
\description{
Predictive distribution of a T-years return level at ungauged positions (targets), given the output from the MCMC procedures \code{hkevp.fit} or \code{latent.fit}.
}
\details{
Spatial extrapolation of the return level at target positions \eqn{(s^*_1, ..., s^*_k)} is a two-step procedure:
\itemize{
\item{Estimation of the predictive distribution for GEV parameters at \eqn{(s^*_1, ..., s^*_k)}, by using \code{{extrapol.gev}}.}
\item{Computation of the associated return level for each state of the predictive distribution.}}
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
loc <- sites[,1]*10
scale <- 1
shape <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, loc, scale, shape, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, niter = 1000)

## Extrapolation of the 100-years return level (may need more iterations and burn-in/nthin):
targets <- as.matrix(expand.grid(1.5:2.5,1.5:2.5))
pred.sample <- extrapol.return.level(100, fit, targets)
pred.mean <- apply(pred.sample, 2, mean)
pred.sd <- apply(pred.sample, 2, sd)
true <- return.level(100, targets[,1]*10, scale, shape)
# cbind(true, pred.mean, pred.sd)



}
\author{
Quentin Sebille
}
\seealso{
\code{\link{extrapol.gev}}
}

