% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.expmeasure.R
\name{posterior.expmeasure}
\alias{posterior.expmeasure}
\title{Posterior distribution of the HKEVP exponent measure}
\usage{
posterior.expmeasure(fit, sites, z)
}
\arguments{
\item{fit}{A named list.
Output from the \code{hkevp.fit} procedure.}

\item{sites}{A matrix of real values.
Coordinates of the sites where the exponent measure is evaluated. Each row corresponds to a position and each column to a coordinate.}

\item{z}{A numerical vector.
Vector \eqn{(z_1,...,z_n)} where the exponent measure is computed.}
}
\value{
A numerical vector.
Exponent measure evaluated at each MCMC step.
}
\description{
This function returns the posterior distribution of the exponent measure \eqn{V(z_1, ..., z_n)} evaluated at the set of sites \eqn{(s_1, ..., s_n)}, computed from the output of \code{hkevp.fit}
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
mu <- sites[,1]*10
sigma <- 3
xi <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, mu, sigma, xi, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, knots, niter = 100, nburn = 50, quiet = FALSE)

## Exponent measure:
z <- rep(1, 2)
postem <- posterior.expmeasure(fit, sites[1:2,], z)
print(median(postem))
print(sd(postem))




}
\author{
Quentin Sebille
}
\seealso{
\link{hkevp.expmeasure}
}

