% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hkevp.rand.R
\name{hkevp.rand}
\alias{hkevp.rand}
\title{Simulation of the HKEVP}
\usage{
hkevp.rand(nrep, sites, knots, mu, sigma, xi, alpha, tau)
}
\arguments{
\item{nrep}{A positive integer.
Number of realisations of the block maxima process.}

\item{sites}{A numerical matrix of real values.
Coordinates for the sites positions: each row corresponds to a position and each column to a spatial coordinate.}

\item{knots}{A numerical matrix of real values.
Coordinates of the knots: each row corresponds to a knot position and each column to a spatial coordinate. If missing, \code{knots} is equal to \code{sites}.}

\item{mu}{A numerical value or a vector of real values.
GEV location parameter. If \code{mu} is a vector, its length must coincide with the number of sites.}

\item{sigma}{A numerical value or a vector of positive values.
GEV scale parameter. If \code{sigma} is a vector, its length must coincide with the number of sites.}

\item{xi}{A numerical value or a vector of real values.
GEV shape parameter. If \code{xi} is a vector, its length must coincide with the number of sites.}

\item{alpha}{A numerical value in (0,1].
Dependence parameter \eqn{\alpha} in the HKEVP. Low value (resp. value close to 1) corresponds to the limit case of complete spatial dependence (resp. independence).}

\item{tau}{A positive numerical value.
Bandwidth parameter \eqn{\tau} of the kernel functions in the HKEVP.}
}
\value{
A numerical matrix of real values.
Each column corresponds to a position and each row to a realisation of the process.
}
\description{
Simulation procedure of the HKEVP with given sites and knots positions and marginal and spatial dependence parameters.
}
\details{
Simulating one realisation of the block maxima process \eqn{Y(\cdot)} from the HKEVP involves three steps:
\enumerate{
\item The \emph{nugget process} \eqn{U(\cdot)} is generated independently at each position, by simulating a random variable with \eqn{GEV(1,\alpha,\alpha)} distribution.
\item The \emph{residual dependence process} \eqn{\theta(\cdot)} is computed by using the kernel functions centered at the set of knots, the bandwidth parameter \eqn{\tau} and the simulations of the positive stable \eqn{PS(\alpha)} random effect \eqn{A}.
\item The process \eqn{Z = U\theta} is computed and its margins are transformed to the general GEV distribution with \eqn{\mu(s),\sigma(s)} and \eqn{\xi(s)} parameters.
}
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
mu <- sites[,1]*10
sigma <- 3
xi <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, mu, sigma, xi, alpha, tau)





}
\author{
Quentin Sebille
}

