% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estintens.R
\name{est_intens}
\alias{est_intens}
\title{Estimates the intensity of the point pattern.}
\usage{
est_intens(ppdata, covmatrix = NULL, weights = NULL)
}
\arguments{
\item{ppdata}{data of class ppp}

\item{covmatrix}{(Optional) Covariance matrix of the kernel of a normal distribution}

\item{weights}{(Optional) vector of weights attached to each observation}
}
\value{
A list of
   \item{ intensest }{ Estimated intensity (object of class "im", see \code{\link[spatstat]{density.ppp}}). }
   \item{ covmatrix }{ Covariance matrix. If \code{covmatrix = NULL}, the matrix is estimated by \code{\link[ks]{Hscv}}. }
}
\description{
Estimates the intensity of the point pattern by a kernel method
(See \code{\link[spatstat]{density.ppp}}).
}
\examples{
data(craterA)
#change npixel = 50 to 1000 to get a nicer picture
spatstat::spatstat.options(npixel=50)
# use only ten observations for fast computation
thin.craterA <- craterA[1:10]
int <- est_intens(thin.craterA)
# Plot estimated intensity
plot(int$intensest, main = "pixel image of intensity")
plot(craterA$window, main = "contour plot of intensity")
contour(int$intensest, add =TRUE)
}
\seealso{
\code{\link[spatstat]{density.ppp}}, \code{\link[ks]{Hscv}}, \code{\link[spatstat]{eval.im}}
}
