% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust-mstep.R
\name{robust_mstep}
\alias{robust_mstep}
\title{the M step function of the EM algorithm}
\usage{
robust_mstep(x, wt, control = list(k = 1.345))
}
\arguments{
\item{x}{the observation matrix}

\item{wt}{the state probabilities matrix (number of observations
times number of states)}

\item{control}{a list containing the control parameter k with the default
value equal to 1.345}
}
\value{
list of emission parameters:
(\code{mu} and \code{sigma})
}
\description{
The M step function of the EM algorithm for the robust emission proposed by
Qin et al. (2024) using the
observation matrix and the estimated weight vectors
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- c(FALSE, TRUE, FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), nrow = J, 
byrow = TRUE)
par <- list(mu = list(list(7, 8), list(10, 9, 11), list(12, 14)),
sigma = list(list(3.8, 4.9), list(4.3, 4.2, 5.4), list(4.5, 6.1)),
mix.p = list(c(0.3, 0.7), c(0.2, 0.3, 0.5), c(0.5, 0.5)))
sojourn <- list(shape = c(0, 3, 0), scale = c(0, 10, 0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
train <- simulate(model, nsim = c(10, 8, 8, 18), seed = 1234, 
remission = rmixmvnorm)
clus = initial_cluster(train, nstate = 3, nmix = NULL ,ltr = FALSE,
final.absorb = FALSE, verbose = TRUE)
initmodel1 = initialize_model(clus = clus, sojourn = "gamma", 
M = max(train$N), semi = semi, dens.emission = drobust, mstep = robust_mstep)
# not test
# fit1 = hhsmmfit(x = train, model = initmodel1, M = max(train$N), 
# mstep = robust_mstep)


}
\references{
Qin, S., Tan, Z., & Wu, Y. (2024). On robust estimation of hidden semi-Markov
regime-switching models. Annals of Operations Research, 1-33.
}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
