% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmvnorm-mix-hhsmm.R
\name{dmixmvnorm}
\alias{dmixmvnorm}
\title{pdf of the mixture of multivariate normals for hhsmm}
\usage{
dmixmvnorm(x, j, model)
}
\arguments{
\item{x}{an observation vector or matrix}

\item{j}{a specified state between 1 to nstate}

\item{model}{a hhsmmspec model}
}
\value{
the probability density function value
}
\description{
The probability density function of a mixture multivariate normal
for a specified observation vector, a specified state and a specified
model's parameters
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- c(FALSE, TRUE, FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), 
nrow = J, byrow = TRUE)
par <- list(mu = list(list(7, 8),list(10, 9, 11), list(12, 14)),
sigma = list(list(3.8, 4.9), list(4.3, 4.2, 5.4), list(4.5, 6.1)),
mix.p = list(c(0.3, 0.7), c(0.2, 0.3, 0.5), c(0.5, 0.5)))
sojourn <- list(shape = c(0, 3, 0), scale = c(0, 10, 0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
train <- simulate(model, nsim = c(10, 8, 8, 18), seed = 1234, 
remission = rmixmvnorm)
p = dmixmvnorm(train$x, 1, model)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat, \email{aftbayat@gmail.com}
}
