% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.hfr.R
\name{plot.cv.hfr}
\alias{plot.cv.hfr}
\title{Plot the dendrogram of an HFR model}
\usage{
\method{plot}{cv.hfr}(x, kappa = NULL, show_details = TRUE, max_leaf_size = 3, ...)
}
\arguments{
\item{x}{Fitted 'cv.hfr' model.}

\item{kappa}{The hyperparameter used for plotting. If empty, the optimal value is used.}

\item{show_details}{print model details on the plot.}

\item{max_leaf_size}{maximum size of the leaf nodes. Default is \code{max_leaf_size=3}.}

\item{...}{additional methods passed to \code{plot}.}
}
\value{
A plotted dendrogram.
}
\description{
Plots the dendrogram of a fitted \code{cv.hfr} model. The heights of the
levels in the dendrogram are given by a shrinkage vector, with a maximum (unregularized)
overall graph height of \eqn{p}{p} (the number of covariates in the regression).
Stronger shrinkage leads to a shallower hierarchy.
}
\details{
The dendrogram is generated using hierarchical clustering and modified
so that the height differential between any two splits is the shrinkage weight of
the lower split (ranging between \code{0} and \code{1}). With no shrinkage, all shrinkage weights
are equal to \code{1} and the dendrogram has a height of \eqn{p}{p}. With shrinkage
the dendrogram has a height of \eqn{(\kappa \times p)}{(\code{kappa} x p)}.

The leaf nodes are colored to indicate the coefficient sign, with the size indicating
the absolute magnitude of the coefficients.

A color bar on the right indicates the relative contribution of each level to the
coefficient of determination, with darker hues representing a larger contribution.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = cv.hfr(x, y, kappa_grid = seq(0, 1, by = 0.1))
plot(fit, kappa = 0.5)

}
\seealso{
\code{hfr}, \code{predict} and \code{coef} methods
}
\author{
Johann Pfitzinger
}
