% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_net.R
\name{causal_net}
\alias{causal_net}
\title{Create a Causal net (also Heuristics net)}
\usage{
causal_net(
  eventlog = NULL,
  dependencies = dependency_matrix(eventlog = eventlog, threshold = threshold,
    threshold_frequency = threshold_frequency, ...),
  bindings = causal_bindings(eventlog, dependencies),
  threshold = 0.9,
  threshold_frequency = 0,
  type = causal_frequency("absolute"),
  sec = NULL,
  type_nodes = type,
  type_edges = type,
  sec_nodes = sec,
  sec_edges = sec,
  ...
)
}
\arguments{
\item{eventlog}{The event log for which a causal map should be computed.
Can be left NULL for more control if parameters \code{dependencies} and \code{bindings} are provided directly.}

\item{dependencies}{A dependency matrix created for the event log, for example, by \code{\link{dependency_matrix}}.}

\item{bindings}{Causal bindings created by \code{\link{causal_bindings}}.}

\item{threshold}{The dependency threshold to be used when using the default dependency matrix computation.}

\item{threshold_frequency}{The frequency threshold to be used when using the default dependency matrix computation.}

\item{type}{A causal map type. For example, \code{\link{causal_frequency}} or \code{\link{causal_performance}}.}

\item{sec}{A causal process map type. Values are shown between brackets.}

\item{type_nodes}{A causal map type to be used for nodes only.}

\item{type_edges}{A causal map type to be used for edges only.}

\item{sec_nodes}{A secondary causal map type for nodes only.}

\item{sec_edges}{A secondary causal map type for edges only.}

\item{...}{Further parameters forwarded to the default \code{\link{dependency_matrix}} function.}
}
\value{
A DiagrammeR graph of the causal map.
}
\description{
Creates a Causal net, also known as Heuristics net. This is similar to a processmapR process map.
However, the causal map deals with parallelism by trying to identifying causal dependencies
between activities by using different heuristics as documented in \code{\link{dependency_matrix}}.
}
\details{
Warning: Projected frequencies are heuristically determined and counts may not add up.
}
\examples{
# Causal map with default parameters
causal_net(L_heur_1)

# Causal map with lower dependency treshold
causal_net(L_heur_1, threshold = .8)

# For even more control omit the `eventlog` parameter
# and provide `dependencies` and `bindings` directly.
d <- dependency_matrix(L_heur_1, threshold = .8)
causal_net(dependencies = d,
           bindings = causal_bindings(L_heur_1, d, "nearest"))

# The returned DiagrammeR object can be further augmented with
# panning and zooming before rendering:
\donttest{
library(magrittr)
causal_net(L_heur_1) \%>\%
 render_causal_net(render = TRUE) \%>\%
 DiagrammeRsvg::export_svg() \%>\%
 svgPanZoom::svgPanZoom()
}

}
