% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{regModel}
\alias{regModel}
\title{Linear regression (no intercept) wrapper for hueristica}
\usage{
regModel(train_matrix, criterion_col, cols_to_fit, fit_name = "regModel")
}
\arguments{
\item{train_matrix}{A matrix (or data.frame) of data to train (fit) the
model with.}

\item{criterion_col}{The index of the criterion column-- "y" in the formula.}

\item{cols_to_fit}{A vector of column indexes to fit-- the "x's" in the
formula.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.}
}
\value{
An object of class regModel, which is a subclass of lm.
}
\description{
A wrapper to create a lm model just specifying columns, generating
a model formula for you __without an intercept__.
This makes it easier to run automated comparisons with
other models in heuristica.
}
\details{
This version assumes you do NOT want to include the intercept.
Excluding the intercept typically has higher out-of-sample accuracy if the
goal is predicting rank order because the intercept does not affect the
ranking, but estimating it wastes a degree of freedom.
}
\seealso{
\code{\link{lm}} for the regression function being wrapped.

\code{\link{predictPair}} for predicting whether row1 is greater.
greater.
}
