% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heumilkr_solution.R
\name{milkr_cost}
\alias{milkr_cost}
\title{Vehicle runs cost / distance}
\usage{
milkr_cost(solution)
}
\arguments{
\item{solution}{A "\code{heumilkr_solution}" object, typically obtained by \code{\link[=clarke_wright]{clarke_wright()}}.}
}
\value{
The total traveled distance.
}
\description{
Calculates the total distance associated to a \code{\link[=clarke_wright]{clarke_wright()}} result.
This is the measure that the corresponding Capacitated Vehicle Routing
Problem minimizes.
}
\examples{
demand <- c(3, 2, 4, 2)

positions <-
  data.frame(
    pos_x = c(0, 1, -1, 2, 3),
    pos_y = c(0, 1, 1, 2, 3)
  )

solution <- clarke_wright(
  demand,
  dist(positions),
  data.frame(n = NA_integer_, caps = 6)
)

milkr_cost(solution)

}
