% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R
\name{find_reps}
\alias{find_reps}
\title{Data preprocessing}
\usage{
find_reps(
  X,
  Z,
  return.Zlist = TRUE,
  rescale = FALSE,
  normalize = FALSE,
  inputBounds = NULL
)
}
\arguments{
\item{X}{matrix of design locations, one point per row}

\item{Z}{vector of observations at \code{X}}

\item{return.Zlist}{to return \code{Zlist}, see below}

\item{rescale}{if \code{TRUE}, the inputs are rescaled to the unit hypercube}

\item{normalize}{if \code{TRUE}, the outputs are centered and normalized}

\item{inputBounds}{optional matrix of known boundaries in original input space, of size 2 times \code{ncol(X)}. 
If not provided, and \code{rescale == TRUE}, it is estimated from the data.}
}
\value{
A list with the following elements that can be passed to the main fitting functions, e.g., \code{\link{mleHetGP}} and \code{\link{mleHomGP}}
\itemize{
\item \code{X0} matrix with unique designs locations, one point per row,
\item \code{Z0} vector of averaged observations at \code{X0},
\item \code{mult} number of replicates at \code{X0},
\item \code{Z} vector with all observations, sorted according to \code{X0},
\item \code{Zlist} optional list, each element corresponds to observations at a design in \code{X0},
\item \code{inputBounds} optional matrix, to rescale back to the original input space,
\item \code{outputStats} optional vector, with mean and variance of the original outputs.
}
}
\description{
Prepare data for use with \code{\link[hetGP]{mleHetGP}}, in particular to find replicated observations
}
\details{
Replicates are searched based on character representation, using \code{\link[base]{unique}}.
}
\examples{
##------------------------------------------------------------
## Find replicates on the motorcycle data
##------------------------------------------------------------
## motorcycle data
library(MASS)
X <- matrix(mcycle$times, ncol = 1)
Z <- mcycle$accel

data_m <- find_reps(X, Z)

# Initial data
plot(X, Z, ylim = c(-160, 90), ylab = 'acceleration', xlab = "time")
# Display mean values
points(data_m$X0, data_m$Z0, pch = 20)
}
