% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_univar.R
\name{merge_pair.hermite_estimator_univar}
\alias{merge_pair.hermite_estimator_univar}
\title{Merges two Hermite estimators}
\usage{
\method{merge_pair}{hermite_estimator_univar}(h_est_obj, hermite_estimator_other)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_univar object. The first Hermite series 
based estimator.}

\item{hermite_estimator_other}{A hermite_estimator_univar object. The 
second Hermite series based estimator.}
}
\value{
An object of class hermite_estimator_univar.
}
\description{
This method allows a pair of Hermite based estimators of class
hermite_estimator_univar to be consistently merged.
}
\details{
Note that the N and standardize arguments must be the same for the two
estimators in order to merge them. In addition, note that exponentially
weighted estimators cannot be merged. If the Hermite estimators are not
standardized, the merged estimator will be exactly equivalent to
constructing a single estimator on the data set formed by combining the
data sets used to update the respective hermite_estimator_univar inputs.
If the input Hermite estimators are standardized however, then the
equivalence will be approximate but still accurate in most cases.
}
