% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{cum_prob}
\alias{cum_prob}
\title{Estimates the cumulative probability at one or more x values}
\usage{
cum_prob(this, x, clipped)
}
\arguments{
\item{this}{A hermite_estimator_univar or hermite_estimator_bivar object.}

\item{x}{A numeric vector (univariate) or a numeric matrix (bivariate).
Values at which to calculate the cumulative probability.}

\item{clipped}{A boolean value. This value determines whether
cumulative probabilities are clipped to lie between 0 and 1.}
}
\value{
A numeric vector of cumulative probability values.
}
\description{
This method calculates the cumulative probability at a vector of
x values in the univariate case. In the bivariate case, the method calculates
the probability density values for a matrix of x values, each row of which 
represents a 2-d point.
}
\details{
The object must be updated with observations prior to the use of the method.
}
\examples{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="univariate")
hermite_est <- update_batch(hermite_est, rnorm(30))
cdf_est <- cum_prob(hermite_est, c(0, 0.5, 1))
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="bivariate")
hermite_est <- update_batch(hermite_est, x = matrix(rnorm(60), 
nrow=30, ncol=2,byrow=TRUE))
cdf_est <- cum_prob(hermite_est, matrix(c(0,0,0.5,0.5,1,1),nrow=3,
ncol=2,byrow=TRUE))
}
