% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{HERE Geocoder API: Geocode}
\usage{
geocode(addresses, autocomplete = FALSE, url_only = FALSE)
}
\arguments{
\item{addresses}{character, addresses to geocode.}

\item{autocomplete}{boolean, use the 'Geocoder Autocomplete' API to autocomplete addresses? Note: This options doubles the amount of requests (\code{default = FALSE}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object, containing the coordinates of the geocoded addresses.
}
\description{
Geocodes addresses using the 'Geocoder' API.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

locs <- geocode(addresses = poi$city, url_only = TRUE)
}
\references{
\href{https://developer.here.com/documentation/geocoder/topics/resource-geocode.html}{HERE Geocoder API: Geocode}
}
