% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_end_to_fill.R
\name{start_end_to_fill}
\alias{start_end_to_fill}
\title{Function for filling start and end gaps in time series}
\usage{
start_end_to_fill(data, calendar, gap_variable, key_variable, time_variable)
}
\arguments{
\item{data}{a R data frame}

\item{calendar}{a R data frame containing a complete empty calendar (as one can performs with \code{create_calendar_day})}

\item{gap_variable}{a character. This represents the name of the variable we want to fill the start and end gaps}

\item{key_variable}{a character. This represents the variable name that refers to the key variable in the panel data (an ID, ...)}

\item{time_variable}{a character. This represents the time variable name that permits to sort observation on a time scale}
}
\value{
a R data frame that contains the original columns and a new one:
\itemize{
 \item \code{gap_variable}_corrected_1: the gap variable with starts and ends filled
 }
}
\description{
This function allows to fill the start and end gaps of a time series
by doing repetition of next (for the start) and previous values (for the end)
}
\examples{
library(dplyr)

# We take three countries from 2011 to 2018
fr_sp_ge_pop <- world_countries_pop \%>\%
filter(country_name \%in\% c('France', 'Spain', 'Germany')) \%>\%
filter(year > 2010) \%>\%
arrange(country_name, year)

# We artificially create some gaps in time series
fr_sp_ge_pop$population[c(1, 5, 11, 12, 24)] <- NA
fr_sp_ge_pop <- na.omit(fr_sp_ge_pop)

data_1 <- create_calendar(data = fr_sp_ge_pop, key_variable = "country_code",
time_variable = "year", start_year = 2011, end_year = 2018)
data_2 <- start_end_to_fill(data = fr_sp_ge_pop, calendar = data_1, gap_variable = "population",
key_variable = "country_code", time_variable = "year")
data_3 <- gap_to_fill(data = data_2, gap_variable = "population_corrected_1",
key_variable = "country_code", time_variable = "year", digits = 1)
}
\references{
Link to the author's github package repository:
\url{https://github.com/Redcart/helda}
}
\seealso{
\code{\link{create_calendar}} \code{\link{gap_to_fill}}
}
\author{
Simon CORDE
}
\keyword{fill}
\keyword{gaps}
\keyword{series}
\keyword{time}
