% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift_curve.R
\name{lift_curve}
\alias{lift_curve}
\title{Lift curve graph}
\usage{
lift_curve(predictions, true_labels, positive_label)
}
\arguments{
\item{predictions}{a vector of predictions. These are generally the result of a machine learning model.
The predictions must be probabilities (a real number between 0 and 1).}

\item{true_labels}{a vector of true labels.}

\item{positive_label}{a character or integer that specify the positive label (Y=1) in the `true_labels`.}
}
\value{
a ggplot object containing the lift curve.
}
\description{
This function allows to draw a lift curve in a ggplot style for binary classification model
}
\examples{
data_training <- titanic_training
data_validation <- titanic_validation
model_glm <- glm(formula = "Survived ~ Pclass + Sex + Age + SibSp + Fare + Embarked",
data = data_training,
family = binomial(link = "logit"))
predictions <- predict(object = model_glm, newdata = data_validation, type = "response")
plot <- lift_curve(predictions = predictions, true_labels = data_validation$Survived,
positive_label = 1)
plot
}
\references{
Link to the author's github package repository:
\url{https://www.github.com/Redcart/helda}
}
\seealso{
lift_effect
}
\author{
Simon CORDE
}
\keyword{classification}
\keyword{curve}
\keyword{learning}
\keyword{lift}
\keyword{machine}
