% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamp_print.R
\name{plot.psa}
\alias{plot.psa}
\title{Plot Results of Probabilistic Analysis}
\usage{
\method{plot}{psa}(x, type = c("ce", "ac", "cov"), max_wtp = 1e+05,
  n = 100, log_scale = TRUE, bw = FALSE, ...)
}
\arguments{
\item{x}{Result from \code{\link{run_model}}.}

\item{type}{Type of plot, see details.}

\item{max_wtp}{Maximal willingness to pay.}

\item{n}{Number of CECA points to estimate (values above
100 may take significant time).}

\item{log_scale}{Show willingness to pay on a log scale?}

\item{bw}{Black & white plot for publications?}

\item{...}{Additional arguments passed to \code{plot}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Various plots for Markov models probabilistic analysis.
}
\details{
\code{type = "ac"} plots cost-effectiveness acceptability
curves, \code{type = "ce"} plots results on the 
cost-efficiency plane, \code{type = "cov"} to perform
covariance analysis on the results.
}

